/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.PortIterable;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class NorthSouthEdgeAllCrossingsCounter {
    private final Map<LNode, Integer> nodePositions;
    private final Map<LPort, Integer> portPositions;
    private final Map<LNode, Integer> northCardinalities;
    private final Map<LNode, Integer> southCardinalities;
    private final LNode[] layer;
    private LNode currentOriginNode;
    private int numberOfNorthSouthEdges;
    private int numberOfLongEdgeDummies;
    private boolean northOfCurrentOriginNode = true;
    private final boolean usesOrthogonalCounter;

    public NorthSouthEdgeAllCrossingsCounter(LNode[] layer) {
        this.layer = layer;
        this.nodePositions = Maps.newHashMap();
        this.portPositions = Maps.newHashMap();
        this.northCardinalities = Maps.newHashMap();
        this.southCardinalities = Maps.newHashMap();
        this.usesOrthogonalCounter = layer[0].getGraph().getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL;
        this.initPositionsAndCardinalities();
    }

    private void initPositionsAndCardinalities() {
        int nodeId = 0;
        LNode[] lNodeArray = this.layer;
        int n = this.layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode element = lNodeArray[n2];
            LNode node = element;
            if (!this.isLongEdgeDummy(node)) {
                this.nodePositions.put(node, nodeId++);
            }
            this.setPortPositionsAndCardinalitiesFor(node, this.northCardinalities, PortSide.NORTH);
            this.setPortPositionsAndCardinalitiesFor(node, this.southCardinalities, PortSide.SOUTH);
            ++n2;
        }
    }

    private void setPortPositionsAndCardinalitiesFor(LNode node, Map<LNode, Integer> cardinalities, PortSide side) {
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, side);
        int portId = 0;
        for (LPort port : ports) {
            this.portPositions.put(port, portId++);
        }
        cardinalities.put(node, portId);
    }

    public int countCrossings() {
        int crossings = 0;
        LNode[] lNodeArray = this.layer;
        int n = this.layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            crossings += this.getLongEdgeDummyCrossings(node);
            if (this.fixedPortOrderOn(node)) {
                if (this.hasPortOnSide(node, PortSide.NORTH)) {
                    crossings += this.getCrossingsOnSide(node, PortSide.NORTH);
                }
                if (this.hasPortOnSide(node, PortSide.SOUTH)) {
                    crossings += this.getCrossingsOnSide(node, PortSide.SOUTH);
                }
            }
            ++n2;
        }
        return crossings;
    }

    private int getLongEdgeDummyCrossings(LNode node) {
        int crossings = 0;
        if (this.isNorthSouth(node)) {
            if (this.originIsNotCurrentOrigin(node)) {
                this.resetDummyCountAndSetCurrentOriginNodeTo(this.originPortOf(node).getNode());
                this.northOfCurrentOriginNode = true;
            }
            if (this.northOfCurrentOriginNode) {
                ++this.numberOfNorthSouthEdges;
            } else {
                crossings += this.numberOfLongEdgeDummies;
            }
        } else if (this.isLongEdgeDummy(node)) {
            if (this.northOfCurrentOriginNode) {
                crossings += this.numberOfNorthSouthEdges;
            } else {
                ++this.numberOfLongEdgeDummies;
            }
        } else if (this.isNormal(node)) {
            this.resetDummyCountAndSetCurrentOriginNodeTo(node);
            this.northOfCurrentOriginNode = false;
        }
        return crossings;
    }

    private boolean originIsNotCurrentOrigin(LNode node) {
        return !((Object)((Object)this.originPortOf(node).getNode())).equals((Object)this.currentOriginNode);
    }

    private void resetDummyCountAndSetCurrentOriginNodeTo(LNode node) {
        this.currentOriginNode = node;
        this.numberOfNorthSouthEdges = 0;
        this.numberOfLongEdgeDummies = 0;
    }

    private boolean isNormal(LNode node) {
        return node.getType() == LNode.NodeType.NORMAL;
    }

    private boolean isLongEdgeDummy(LNode node) {
        return node.getType() == LNode.NodeType.LONG_EDGE;
    }

    private boolean isNorthSouth(LNode node) {
        return node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    private int getCrossingsOnSide(LNode node, PortSide side) {
        int crossings = 0;
        Iterable<LPort> southPorts = node.getPorts(side);
        for (LPort port : southPorts) {
            if (!this.hasConnectedEdge(port)) continue;
            LNode northSouthDummy = this.getConnectedNorthSouthDummy(port);
            if (this.hasPortOnSide(northSouthDummy, PortSide.EAST)) {
                crossings += this.numberOfEasternCrossings(node, port, northSouthDummy, side);
            }
            if (!this.hasPortOnSide(northSouthDummy, PortSide.WEST)) continue;
            crossings += this.numberOfWesternCrossings(node, port, northSouthDummy, side);
        }
        return crossings;
    }

    private boolean hasConnectedEdge(LPort port) {
        return this.getConnectedNorthSouthDummy(port) != null;
    }

    private int numberOfWesternCrossings(LNode node, LPort port, LNode northSouthDummy, PortSide side) {
        int factor = this.usesOrthogonalCounter ? 1 : northSouthDummy.getPorts().get(0).getDegree();
        return factor * Math.min(this.positionOf(port), this.nearnessBetween(node, northSouthDummy));
    }

    private int numberOfEasternCrossings(LNode node, LPort port, LNode northSouthDummy, PortSide side) {
        int factor = this.usesOrthogonalCounter ? 1 : northSouthDummy.getPorts().get(0).getDegree();
        return factor * Math.min(this.cardinalityOnSide(node, side) - 1 - this.positionOf(port), this.nearnessBetween(node, northSouthDummy));
    }

    private boolean fixedPortOrderOn(LNode node) {
        return ((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed();
    }

    private boolean hasPortOnSide(LNode node, PortSide side) {
        return this.getPortIteratorForSide(node, side).hasNext();
    }

    private LNode getConnectedNorthSouthDummy(LPort port) {
        return (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
    }

    private int nearnessBetween(LNode node, LNode northSouthDummy) {
        PortSide dummySide = this.getSideOf(northSouthDummy);
        int cardinality = this.cardinalityOnSide(node, dummySide);
        return cardinality - Math.abs(this.positionOf(node) - this.positionOf(northSouthDummy));
    }

    private Integer cardinalityOnSide(LNode node, PortSide side) {
        switch (side) {
            case NORTH: {
                return this.northCardinalities.get((Object)node);
            }
            case SOUTH: {
                return this.southCardinalities.get((Object)node);
            }
        }
        assert (false) : "Cardinality for port side " + side + " has not been collected!";
        return 0;
    }

    private int positionOf(LNode node) {
        return this.nodePositions.get((Object)node);
    }

    private int positionOf(LPort port) {
        return this.portPositions.get((Object)port);
    }

    private PortSide getSideOf(LNode northSouthDummy) {
        return this.originPortOf(northSouthDummy).getSide();
    }

    private LPort originPortOf(LNode node) {
        LPort port = node.getPorts().get(0);
        LPort origin = (LPort)((Object)port.getProperty(InternalProperties.ORIGIN));
        return origin;
    }

    private Iterator<LPort> getPortIteratorForSide(LNode node, PortSide side) {
        return node.getPorts(side).iterator();
    }

    public void notifyNodeSwitch(LNode nodeOne, LNode nodeTwo) {
        if (this.nodePositions.containsKey((Object)nodeOne) && this.nodePositions.containsKey((Object)nodeTwo)) {
            int formerPositionOfOne = this.nodePositions.get((Object)nodeOne);
            this.nodePositions.put(nodeOne, this.nodePositions.get((Object)nodeTwo));
            this.nodePositions.put(nodeTwo, formerPositionOfOne);
        }
    }
}

