/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;

public final class OrthogonalRoutingGenerator {
    public static final double TOLERANCE = 0.001;
    private static final double CONFL_THRESH_FACTOR = 0.2;
    private static final int CONFLICT_PENALTY = 16;
    private final IRoutingDirectionStrategy routingStrategy;
    private final double edgeSpacing;
    private final double conflictThreshold;
    private final Set<KVector> createdJunctionPoints = Sets.newHashSet();
    private final String debugPrefix;

    public OrthogonalRoutingGenerator(RoutingDirection direction, double edgeSpacing, String debugPrefix) {
        switch (direction) {
            case WEST_TO_EAST: {
                this.routingStrategy = new WestToEastRoutingStrategy();
                break;
            }
            case NORTH_TO_SOUTH: {
                this.routingStrategy = new NorthToSouthRoutingStrategy();
                break;
            }
            case SOUTH_TO_NORTH: {
                this.routingStrategy = new SouthToNorthRoutingStrategy();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.edgeSpacing = edgeSpacing;
        this.conflictThreshold = 0.2 * edgeSpacing;
        this.debugPrefix = debugPrefix;
    }

    public int routeEdges(LGraph layeredGraph, Iterable<LNode> sourceLayerNodes, int sourceLayerIndex, Iterable<LNode> targetLayerNodes, double startPos) {
        HashMap portToHyperNodeMap = Maps.newHashMap();
        ArrayList hyperNodes = Lists.newArrayList();
        this.createHyperNodes(sourceLayerNodes, this.routingStrategy.getSourcePortSide(), hyperNodes, portToHyperNodeMap);
        this.createHyperNodes(targetLayerNodes, this.routingStrategy.getTargetPortSide(), hyperNodes, portToHyperNodeMap);
        ListIterator iter1 = hyperNodes.listIterator();
        while (iter1.hasNext()) {
            HyperNode hyperNode1 = (HyperNode)iter1.next();
            ListIterator iter2 = hyperNodes.listIterator(iter1.nextIndex());
            while (iter2.hasNext()) {
                HyperNode hyperNode2 = (HyperNode)iter2.next();
                OrthogonalRoutingGenerator.createDependency(hyperNode1, hyperNode2, this.conflictThreshold);
            }
        }
        if (this.debugPrefix != null) {
            DebugUtil.writeDebugGraph(layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, hyperNodes, this.debugPrefix, "full");
        }
        OrthogonalRoutingGenerator.breakCycles(hyperNodes, (Random)layeredGraph.getProperty(InternalProperties.RANDOM));
        if (this.debugPrefix != null) {
            DebugUtil.writeDebugGraph(layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, hyperNodes, this.debugPrefix, "acyclic");
        }
        OrthogonalRoutingGenerator.topologicalNumbering(hyperNodes);
        int rankCount = -1;
        for (HyperNode node : hyperNodes) {
            if (Math.abs(node.start - node.end) < 0.001) continue;
            rankCount = Math.max(rankCount, node.rank);
            this.routingStrategy.calculateBendPoints(node, startPos);
        }
        this.createdJunctionPoints.clear();
        return rankCount + 1;
    }

    private void createHyperNodes(Iterable<LNode> nodes, PortSide portSide, List<HyperNode> hyperNodes, Map<LPort, HyperNode> portToHyperNodeMap) {
        if (nodes != null) {
            for (LNode node : nodes) {
                for (LPort port : node.getPorts(PortType.OUTPUT, portSide)) {
                    HyperNode hyperNode = portToHyperNodeMap.get((Object)port);
                    if (hyperNode != null) continue;
                    hyperNode = new HyperNode();
                    hyperNodes.add(hyperNode);
                    hyperNode.addPortPositions(port, portToHyperNodeMap);
                }
            }
        }
    }

    private static void createDependency(HyperNode hn1, HyperNode hn2, double minDiff) {
        int crossings2;
        int depValue2;
        if (Math.abs(hn1.start - hn1.end) < 0.001 || Math.abs(hn2.start - hn2.end) < 0.001) {
            return;
        }
        int conflicts1 = OrthogonalRoutingGenerator.countConflicts(hn1.targetPosis, hn2.sourcePosis, minDiff);
        int conflicts2 = OrthogonalRoutingGenerator.countConflicts(hn2.targetPosis, hn1.sourcePosis, minDiff);
        int crossings1 = OrthogonalRoutingGenerator.countCrossings(hn1.targetPosis, hn2.start, hn2.end) + OrthogonalRoutingGenerator.countCrossings(hn2.sourcePosis, hn1.start, hn1.end);
        int depValue1 = 16 * conflicts1 + crossings1;
        if (depValue1 < (depValue2 = 16 * conflicts2 + (crossings2 = OrthogonalRoutingGenerator.countCrossings(hn2.targetPosis, hn1.start, hn1.end) + OrthogonalRoutingGenerator.countCrossings(hn1.sourcePosis, hn2.start, hn2.end)))) {
            new Dependency(hn1, hn2, depValue2 - depValue1);
        } else if (depValue1 > depValue2) {
            new Dependency(hn2, hn1, depValue1 - depValue2);
        } else if (depValue1 > 0 && depValue2 > 0) {
            new Dependency(hn1, hn2, 0);
            new Dependency(hn2, hn1, 0);
        }
    }

    private static int countConflicts(List<Double> posis1, List<Double> posis2, double minDiff) {
        int conflicts = 0;
        if (!posis1.isEmpty() && !posis2.isEmpty()) {
            Iterator<Double> iter1 = posis1.iterator();
            Iterator<Double> iter2 = posis2.iterator();
            double pos1 = iter1.next();
            double pos2 = iter2.next();
            boolean hasMore = true;
            do {
                if (pos1 > pos2 - minDiff && pos1 < pos2 + minDiff) {
                    ++conflicts;
                }
                if (pos1 <= pos2 && iter1.hasNext()) {
                    pos1 = iter1.next();
                    continue;
                }
                if (pos2 <= pos1 && iter2.hasNext()) {
                    pos2 = iter2.next();
                    continue;
                }
                hasMore = false;
            } while (hasMore);
        }
        return conflicts;
    }

    private static int countCrossings(List<Double> posis, double start, double end) {
        int crossings = 0;
        for (double pos : posis) {
            if (pos > end) break;
            if (!(pos >= start)) continue;
            ++crossings;
        }
        return crossings;
    }

    /*
     * Unable to fully structure code
     */
    private static void breakCycles(List<HyperNode> nodes, Random random) {
        sources = Lists.newLinkedList();
        sinks = Lists.newLinkedList();
        nextMark = -1;
        for (HyperNode node : nodes) {
            HyperNode.access$9(node, nextMark--);
            inweight = 0;
            outweight = 0;
            for (Dependency dependency : HyperNode.access$3(node)) {
                outweight += Dependency.access$1(dependency);
            }
            for (Dependency dependency : HyperNode.access$4(node)) {
                inweight += Dependency.access$1(dependency);
            }
            HyperNode.access$10(node, inweight);
            HyperNode.access$11(node, outweight);
            if (outweight == 0) {
                sinks.add(node);
                continue;
            }
            if (inweight != 0) continue;
            sources.add(node);
        }
        unprocessed = Sets.newTreeSet(nodes);
        markBase = nodes.size();
        nextRight = markBase - 1;
        nextLeft = markBase + 1;
        maxNodes = new ArrayList<HyperNode>();
        ** GOTO lbl61
        {
            sink = (HyperNode)sinks.removeFirst();
            unprocessed.remove(sink);
            HyperNode.access$9(sink, nextRight--);
            OrthogonalRoutingGenerator.updateNeighbors(sink, sources, sinks);
            do {
                if (!sinks.isEmpty()) continue block3;
                while (!sources.isEmpty()) {
                    source = (HyperNode)sources.removeFirst();
                    unprocessed.remove(source);
                    HyperNode.access$9(source, nextLeft++);
                    OrthogonalRoutingGenerator.updateNeighbors(source, sources, sinks);
                }
                maxOutflow = -2147483648;
                for (HyperNode node : unprocessed) {
                    outflow = HyperNode.access$12(node) - HyperNode.access$13(node);
                    if (outflow < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxNodes.clear();
                        maxOutflow = outflow;
                    }
                    maxNodes.add(node);
                }
                if (maxNodes.isEmpty()) continue;
                maxNode = (HyperNode)maxNodes.get(random.nextInt(maxNodes.size()));
                unprocessed.remove(maxNode);
                HyperNode.access$9(maxNode, nextLeft++);
                OrthogonalRoutingGenerator.updateNeighbors(maxNode, sources, sinks);
                maxNodes.clear();
lbl61:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = nodes.size() + 1;
        for (HyperNode node : nodes) {
            if (HyperNode.access$14(node) >= markBase) continue;
            v0 = node;
            HyperNode.access$9(v0, HyperNode.access$14(v0) + shiftBase);
        }
        for (HyperNode source : nodes) {
            depIter = HyperNode.access$3(source).listIterator();
            while (depIter.hasNext()) {
                dependency = (Dependency)depIter.next();
                target = Dependency.access$2(dependency);
                if (HyperNode.access$14(source) <= HyperNode.access$14(target)) continue;
                depIter.remove();
                HyperNode.access$4(target).remove(dependency);
                if (Dependency.access$1(dependency) <= 0) continue;
                Dependency.access$3(dependency, target);
                HyperNode.access$3(target).add(dependency);
                Dependency.access$4(dependency, source);
                HyperNode.access$4(source).add(dependency);
            }
        }
    }

    private static void updateNeighbors(HyperNode node, List<HyperNode> sources, List<HyperNode> sinks) {
        for (Dependency dep : node.outgoing) {
            if (dep.target.mark >= 0 || dep.weight <= 0) continue;
            HyperNode hyperNode = dep.target;
            hyperNode.inweight = hyperNode.inweight - dep.weight;
            if (dep.target.inweight > 0 || dep.target.outweight <= 0) continue;
            sources.add(dep.target);
        }
        for (Dependency dep : node.incoming) {
            if (dep.source.mark >= 0 || dep.weight <= 0) continue;
            HyperNode hyperNode = dep.source;
            hyperNode.outweight = hyperNode.outweight - dep.weight;
            if (dep.source.outweight > 0 || dep.source.inweight <= 0) continue;
            sinks.add(dep.source);
        }
    }

    private static void topologicalNumbering(List<HyperNode> nodes) {
        HyperNode node3;
        ArrayList sources = Lists.newArrayList();
        ArrayList rightwardTargets = Lists.newArrayList();
        for (HyperNode node2 : nodes) {
            node2.inweight = node2.incoming.size();
            node2.outweight = node2.outgoing.size();
            if (node2.inweight == 0) {
                sources.add(node2);
            }
            if (node2.outweight != 0 || node2.sourcePosis.size() != 0) continue;
            rightwardTargets.add(node2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            node3 = (HyperNode)sources.remove(0);
            for (Object dep : node3.outgoing) {
                HyperNode target = ((Dependency)dep).target;
                target.rank = Math.max(target.rank, node3.rank + 1);
                maxRank = Math.max(maxRank, target.rank);
                HyperNode hyperNode = target;
                hyperNode.inweight = hyperNode.inweight - 1;
                if (target.inweight != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (HyperNode node3 : rightwardTargets) {
                node3.rank = maxRank;
            }
            while (!rightwardTargets.isEmpty()) {
                node3 = (HyperNode)rightwardTargets.remove(0);
                for (Object dep : node3.incoming) {
                    HyperNode source = ((Dependency)dep).source;
                    if (source.sourcePosis.size() > 0) continue;
                    source.rank = Math.min(source.rank, node3.rank - 1);
                    HyperNode hyperNode = source;
                    hyperNode.outweight = hyperNode.outweight - 1;
                    if (source.outweight != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }

    private static void insertSorted(List<Double> list, double value) {
        ListIterator<Double> listIter = list.listIterator();
        while (listIter.hasNext()) {
            double next = listIter.next().floatValue();
            if (next == value) {
                return;
            }
            if (!(next > value)) continue;
            listIter.previous();
            break;
        }
        listIter.add(value);
    }

    private void addJunctionPointIfNecessary(LEdge edge, HyperNode hyperNode, KVector pos, boolean vertical) {
        double p;
        double d = p = vertical ? pos.y : pos.x;
        if ((p > hyperNode.start && p < hyperNode.end || !hyperNode.sourcePosis.isEmpty() && !hyperNode.targetPosis.isEmpty() && (Math.abs(p - (Double)hyperNode.sourcePosis.getFirst()) < 0.001 && Math.abs(p - (Double)hyperNode.targetPosis.getFirst()) < 0.001 || Math.abs(p - (Double)hyperNode.sourcePosis.getLast()) < 0.001 && Math.abs(p - (Double)hyperNode.targetPosis.getLast()) < 0.001)) && !this.createdJunctionPoints.contains(pos)) {
            KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
            if (junctionPoints == null) {
                junctionPoints = new KVectorChain();
                edge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
            }
            KVector jpoint = new KVector(pos);
            junctionPoints.add((Object)jpoint);
            this.createdJunctionPoints.add(jpoint);
        }
    }

    public static final class Dependency {
        private HyperNode source;
        private HyperNode target;
        private int weight;

        private Dependency(HyperNode thesource, HyperNode thetarget, int theweight) {
            this.target = thetarget;
            this.source = thesource;
            this.weight = theweight;
            this.source.outgoing.add(this);
            this.target.incoming.add(this);
        }

        public String toString() {
            return this.source + "->" + this.target;
        }

        public HyperNode getSource() {
            return this.source;
        }

        public HyperNode getTarget() {
            return this.target;
        }

        public int getWeight() {
            return this.weight;
        }

        static /* synthetic */ void access$3(Dependency dependency, HyperNode hyperNode) {
            dependency.source = hyperNode;
        }

        static /* synthetic */ void access$4(Dependency dependency, HyperNode hyperNode) {
            dependency.target = hyperNode;
        }
    }

    public class HyperNode
    implements Comparable<HyperNode> {
        private List<LPort> ports = Lists.newArrayList();
        private int mark;
        private int rank;
        private double start = Double.NaN;
        private double end = Double.NaN;
        private LinkedList<Double> sourcePosis = Lists.newLinkedList();
        private LinkedList<Double> targetPosis = Lists.newLinkedList();
        private List<Dependency> outgoing = Lists.newArrayList();
        private int outweight;
        private List<Dependency> incoming = Lists.newArrayList();
        private int inweight;

        void addPortPositions(LPort port, Map<LPort, HyperNode> hyperNodeMap) {
            hyperNodeMap.put(port, this);
            this.ports.add(port);
            double pos = OrthogonalRoutingGenerator.this.routingStrategy.getPortPositionOnHyperNode(port);
            this.start = Double.isNaN(this.start) ? pos : Math.min(this.start, pos);
            this.end = Double.isNaN(this.end) ? pos : Math.max(this.end, pos);
            if (port.getSide() == OrthogonalRoutingGenerator.this.routingStrategy.getSourcePortSide()) {
                OrthogonalRoutingGenerator.insertSorted(this.sourcePosis, pos);
            } else {
                OrthogonalRoutingGenerator.insertSorted(this.targetPosis, pos);
            }
            for (LPort otherPort : port.getConnectedPorts()) {
                if (hyperNodeMap.containsKey((Object)otherPort)) continue;
                this.addPortPositions(otherPort, hyperNodeMap);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            Iterator<LPort> portIter = this.ports.iterator();
            while (portIter.hasNext()) {
                LPort port = portIter.next();
                String name = port.getNode().getName();
                if (name == null) {
                    name = "n" + port.getNode().getIndex();
                }
                builder.append(name);
                if (!portIter.hasNext()) continue;
                builder.append(',');
            }
            builder.append('}');
            return builder.toString();
        }

        @Override
        public int compareTo(HyperNode other) {
            return this.mark - other.mark;
        }

        public boolean equals(Object object) {
            if (object instanceof HyperNode) {
                HyperNode other = (HyperNode)object;
                return this.mark == other.mark;
            }
            return false;
        }

        public int hashCode() {
            return this.mark;
        }

        public List<Dependency> getOutgoing() {
            return this.outgoing;
        }

        static /* synthetic */ void access$9(HyperNode hyperNode, int n) {
            hyperNode.mark = n;
        }
    }

    private static interface IRoutingDirectionStrategy {
        public double getPortPositionOnHyperNode(LPort var1);

        public PortSide getSourcePortSide();

        public PortSide getTargetPortSide();

        public void calculateBendPoints(HyperNode var1, double var2);
    }

    private class NorthToSouthRoutingStrategy
    implements IRoutingDirectionStrategy {
        private NorthToSouthRoutingStrategy() {
        }

        @Override
        public double getPortPositionOnHyperNode(LPort port) {
            return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
        }

        @Override
        public PortSide getSourcePortSide() {
            return PortSide.SOUTH;
        }

        @Override
        public PortSide getTargetPortSide() {
            return PortSide.NORTH;
        }

        @Override
        public void calculateBendPoints(HyperNode hyperNode, double startPos) {
            double y = startPos + (double)hyperNode.rank * OrthogonalRoutingGenerator.this.edgeSpacing;
            for (LPort port : hyperNode.ports) {
                double sourcex = port.getAbsoluteAnchor().x;
                for (LEdge edge : port.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double targetx = target.getAbsoluteAnchor().x;
                    if (!(Math.abs(sourcex - targetx) > 0.001)) continue;
                    KVector point1 = new KVector(sourcex, y);
                    edge.getBendPoints().add((Object)point1);
                    OrthogonalRoutingGenerator.this.addJunctionPointIfNecessary(edge, hyperNode, point1, false);
                    KVector point2 = new KVector(targetx, y);
                    edge.getBendPoints().add((Object)point2);
                    OrthogonalRoutingGenerator.this.addJunctionPointIfNecessary(edge, hyperNode, point2, false);
                }
            }
        }
    }

    public static enum RoutingDirection {
        WEST_TO_EAST,
        NORTH_TO_SOUTH,
        SOUTH_TO_NORTH;

    }

    private class SouthToNorthRoutingStrategy
    implements IRoutingDirectionStrategy {
        private SouthToNorthRoutingStrategy() {
        }

        @Override
        public double getPortPositionOnHyperNode(LPort port) {
            return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
        }

        @Override
        public PortSide getSourcePortSide() {
            return PortSide.NORTH;
        }

        @Override
        public PortSide getTargetPortSide() {
            return PortSide.SOUTH;
        }

        @Override
        public void calculateBendPoints(HyperNode hyperNode, double startPos) {
            double y = startPos - (double)hyperNode.rank * OrthogonalRoutingGenerator.this.edgeSpacing;
            for (LPort port : hyperNode.ports) {
                double sourcex = port.getAbsoluteAnchor().x;
                for (LEdge edge : port.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double targetx = target.getAbsoluteAnchor().x;
                    if (!(Math.abs(sourcex - targetx) > 0.001)) continue;
                    KVector point1 = new KVector(sourcex, y);
                    edge.getBendPoints().add((Object)point1);
                    OrthogonalRoutingGenerator.this.addJunctionPointIfNecessary(edge, hyperNode, point1, false);
                    KVector point2 = new KVector(targetx, y);
                    edge.getBendPoints().add((Object)point2);
                    OrthogonalRoutingGenerator.this.addJunctionPointIfNecessary(edge, hyperNode, point2, false);
                }
            }
        }
    }

    private class WestToEastRoutingStrategy
    implements IRoutingDirectionStrategy {
        private WestToEastRoutingStrategy() {
        }

        @Override
        public double getPortPositionOnHyperNode(LPort port) {
            return port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
        }

        @Override
        public PortSide getSourcePortSide() {
            return PortSide.EAST;
        }

        @Override
        public PortSide getTargetPortSide() {
            return PortSide.WEST;
        }

        @Override
        public void calculateBendPoints(HyperNode hyperNode, double startPos) {
            double x = startPos + (double)hyperNode.rank * OrthogonalRoutingGenerator.this.edgeSpacing;
            for (LPort port : hyperNode.ports) {
                double sourcey = port.getAbsoluteAnchor().y;
                for (LEdge edge : port.getOutgoingEdges()) {
                    LPort target = edge.getTarget();
                    double targety = target.getAbsoluteAnchor().y;
                    if (!(Math.abs(sourcey - targety) > 0.001)) continue;
                    KVector point1 = new KVector(x, sourcey);
                    edge.getBendPoints().add((Object)point1);
                    OrthogonalRoutingGenerator.this.addJunctionPointIfNecessary(edge, hyperNode, point1, true);
                    KVector point2 = new KVector(x, targety);
                    edge.getBendPoints().add((Object)point2);
                    OrthogonalRoutingGenerator.this.addJunctionPointIfNecessary(edge, hyperNode, point2, true);
                }
            }
        }
    }
}

