/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.execution;

import org.eclipse.elk.core.debug.ElkDebugPlugin;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ExecutionLabelProvider
extends LabelProvider {
    private static final String IMAGE_PATH = "/icons/execution.gif";
    private Image elementImage = ElkDebugPlugin.imageDescriptorFromPlugin((String)"org.eclipse.elk.core.debug", (String)"/icons/execution.gif").createImage();

    public Image getImage(Object element) {
        if (element instanceof IElkProgressMonitor) {
            return this.elementImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IElkProgressMonitor) {
            IElkProgressMonitor monitor = (IElkProgressMonitor)element;
            String baseText = String.valueOf(monitor.getTaskName()) + ": ";
            double time = monitor.getExecutionTime();
            if (monitor.getSubMonitors().isEmpty()) {
                return String.valueOf(baseText) + this.toString(time);
            }
            double childrenTime = 0.0;
            for (IElkProgressMonitor child : monitor.getSubMonitors()) {
                childrenTime += child.getExecutionTime();
            }
            double localTime = Math.max(time - childrenTime, 0.0);
            return String.valueOf(baseText) + this.toString(time) + " [" + this.toString(localTime) + " local]";
        }
        return null;
    }

    private String toString(double time) {
        if (time >= 1.0) {
            return String.format("%1$.3f s", time);
        }
        return String.format("%1$.3f ms", time * 1000.0);
    }

    public void dispose() {
        super.dispose();
        if (this.elementImage != null) {
            this.elementImage.dispose();
            this.elementImage = null;
        }
    }
}

