/**
 * Copyright (c) 2016 TypeFox GmbH (http://www.typefox.io) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.elk.graph.text;

import org.eclipse.elk.graph.text.AbstractElkGraphRuntimeModule;
import org.eclipse.elk.graph.text.conversion.ElkGraphValueConverterService;
import org.eclipse.elk.graph.text.naming.ElkGraphQualifiedNameProvider;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

/**
 * Use this class to register components for the ElkGraph language.
 */
@SuppressWarnings("all")
public class ElkGraphRuntimeModule extends AbstractElkGraphRuntimeModule {
  @Override
  public Class<? extends IValueConverterService> bindIValueConverterService() {
    return ElkGraphValueConverterService.class;
  }
  
  @Override
  public Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
    return ElkGraphQualifiedNameProvider.class;
  }
}
