/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import com.google.common.math.DoubleMath;
import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.PortContext;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.PortPlacementCalculator;
import org.eclipse.elk.core.options.PortAlignment;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;

public final class HorizontalPortPlacementSizeCalculator {
    private static final double EQUALITY_TOLERANCE = 0.01;

    private HorizontalPortPlacementSizeCalculator() {
    }

    public static void calculateHorizontalPortPlacementSize(NodeContext nodeContext) {
        switch (nodeContext.portConstraints) {
            case FIXED_POS: {
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.NORTH);
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedPosPorts(nodeContext, PortSide.SOUTH);
                break;
            }
            case FIXED_RATIO: {
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.NORTH);
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFixedRatioPorts(nodeContext, PortSide.SOUTH);
                break;
            }
            default: {
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFreePorts(nodeContext, PortSide.NORTH);
                HorizontalPortPlacementSizeCalculator.calculateHorizontalNodeSizeRequiredByFreePorts(nodeContext, PortSide.SOUTH);
            }
        }
    }

    private static void calculateHorizontalNodeSizeRequiredByFixedPosPorts(NodeContext nodeContext, PortSide portSide) {
        double rightmostPortBorder = 0.0;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            rightmostPortBorder = Math.max(rightmostPortBorder, portContext.portPosition.x + portContext.port.getSize().x);
        }
        AtomicCell cell = nodeContext.insidePortLabelCells.get(portSide);
        cell.getPadding().left = 0.0;
        cell.getMinimumContentAreaSize().x = rightmostPortBorder;
    }

    private static void calculateHorizontalNodeSizeRequiredByFixedRatioPorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get(portSide);
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        if (portContexts.isEmpty()) {
            cell.getPadding().left = 0.0;
            cell.getPadding().right = 0.0;
            return;
        }
        boolean includePortLabels = nodeContext.sizeConstraints.contains(SizeConstraint.PORT_LABELS);
        boolean spaceEfficientPortLabels = nodeContext.sizeOptions.contains(SizeOptions.SPACE_EFFICIENT_PORT_LABELS);
        boolean portLabelsInside = nodeContext.portLabelsPlacement == PortLabelPlacement.INSIDE;
        double minWidth = 0.0;
        Iterator portContextIterator = portContexts.iterator();
        PortContext previousPortContext = null;
        double previousPortRatio = 0.0;
        double previousPortWidth = 0.0;
        while (portContextIterator.hasNext()) {
            PortContext currentPortContext = (PortContext)portContextIterator.next();
            double currentPortRatio = (Double)currentPortContext.port.getProperty(PortPlacementCalculator.PORT_RATIO_OR_POSITION);
            double currentPortWidth = currentPortContext.port.getSize().x;
            if (includePortLabels) {
                HorizontalPortPlacementSizeCalculator.setHorizontalPortMargins(nodeContext, portSide, portLabelsInside, !portLabelsInside && spaceEfficientPortLabels, 0.0);
            }
            if (previousPortContext == null) {
                if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.left > 0.0) {
                    minWidth = Math.max(minWidth, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(nodeContext.surroundingPortMargins.left + currentPortContext.portMargin.left, 0.0, currentPortRatio));
                }
            } else {
                double requiredSpace = previousPortWidth + previousPortContext.portMargin.right + nodeContext.portPortSpacing + currentPortContext.portMargin.left;
                minWidth = Math.max(minWidth, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, currentPortRatio));
            }
            previousPortContext = currentPortContext;
            previousPortRatio = currentPortRatio;
            previousPortWidth = currentPortWidth;
        }
        if (nodeContext.surroundingPortMargins != null && nodeContext.surroundingPortMargins.right > 0.0) {
            double requiredSpace = previousPortWidth + nodeContext.surroundingPortMargins.right;
            if (portLabelsInside) {
                requiredSpace += previousPortContext.portMargin.right;
            }
            minWidth = Math.max(minWidth, HorizontalPortPlacementSizeCalculator.minSizeRequiredToRespectSpacing(requiredSpace, previousPortRatio, 1.0));
        }
        cell.getPadding().left = 0.0;
        cell.getMinimumContentAreaSize().x = minWidth;
    }

    static double minSizeRequiredToRespectSpacing(double spacing, double firstRatio, double secondRatio) {
        assert (secondRatio >= firstRatio);
        if (DoubleMath.fuzzyEquals((double)firstRatio, (double)secondRatio, (double)0.01)) {
            return 0.0;
        }
        return spacing / (secondRatio - firstRatio);
    }

    private static void calculateHorizontalNodeSizeRequiredByFreePorts(NodeContext nodeContext, PortSide portSide) {
        AtomicCell cell = nodeContext.insidePortLabelCells.get(portSide);
        if (nodeContext.portContexts.get((Object)portSide).isEmpty()) {
            cell.getPadding().left = 0.0;
            cell.getPadding().right = 0.0;
            return;
        }
        cell.getPadding().left = nodeContext.surroundingPortMargins.left;
        cell.getPadding().right = nodeContext.surroundingPortMargins.right;
        boolean includePortLabels = nodeContext.sizeConstraints.contains(SizeConstraint.PORT_LABELS);
        boolean twoPorts = nodeContext.portContexts.get((Object)portSide).size() == 2;
        boolean portLabelsOutside = nodeContext.portLabelsPlacement == PortLabelPlacement.OUTSIDE;
        boolean spaceEfficientPortLabels = nodeContext.sizeOptions.contains(SizeOptions.SPACE_EFFICIENT_PORT_LABELS);
        boolean uniformPortSpacing = nodeContext.sizeOptions.contains(SizeOptions.UNIFORM_PORT_SPACING);
        double width = 0.0;
        if (!includePortLabels || twoPorts && portLabelsOutside) {
            width = HorizontalPortPlacementSizeCalculator.portWidthPlusPortPortSpacing(nodeContext, portSide, false, false);
        } else if (portLabelsOutside) {
            if (uniformPortSpacing) {
                double maxLabelWidth = HorizontalPortPlacementSizeCalculator.maximumPortLabelWidth(nodeContext, portSide, spaceEfficientPortLabels);
                if (maxLabelWidth > 0.0) {
                    HorizontalPortPlacementSizeCalculator.setHorizontalPortMargins(nodeContext, portSide, false, false, maxLabelWidth);
                }
                width = HorizontalPortPlacementSizeCalculator.portWidthPlusPortPortSpacing(nodeContext, portSide, true, false);
            } else {
                HorizontalPortPlacementSizeCalculator.setHorizontalPortMargins(nodeContext, portSide, false, spaceEfficientPortLabels, 0.0);
                width = HorizontalPortPlacementSizeCalculator.portWidthPlusPortPortSpacing(nodeContext, portSide, true, false);
            }
        } else if (!portLabelsOutside) {
            if (uniformPortSpacing) {
                int ports = nodeContext.portContexts.get((Object)portSide).size();
                double maxPortOrLabelWidth = HorizontalPortPlacementSizeCalculator.maximumPortOrLabelWidth(nodeContext, portSide);
                width = maxPortOrLabelWidth * (double)ports + nodeContext.portPortSpacing * (double)(ports - 1);
                if (maxPortOrLabelWidth > 0.0) {
                    HorizontalPortPlacementSizeCalculator.setHorizontalPortMargins(nodeContext, portSide, true, false, maxPortOrLabelWidth);
                }
            } else {
                HorizontalPortPlacementSizeCalculator.setHorizontalPortMargins(nodeContext, portSide, true, false, 0.0);
                width = HorizontalPortPlacementSizeCalculator.portWidthPlusPortPortSpacing(nodeContext, portSide, true, true);
            }
        } else assert (false);
        if (nodeContext.getPortAlignment(portSide) == PortAlignment.DISTRIBUTED) {
            width += 2.0 * nodeContext.portPortSpacing;
        }
        cell.getMinimumContentAreaSize().x = width;
    }

    private static double maximumPortLabelWidth(NodeContext nodeContext, PortSide portSide, boolean ignoreFirstPort) {
        boolean ignore = ignoreFirstPort;
        PrimitiveIterator.OfDouble labelCellWidths = nodeContext.portContexts.get((Object)portSide).stream().mapToDouble(portContext -> portContext.portLabelCell == null ? 0.0 : portContext.portLabelCell.getMinimumWidth()).iterator();
        double maxLabelWidth = 0.0;
        while (labelCellWidths.hasNext()) {
            if (ignore) {
                labelCellWidths.nextDouble();
                ignore = false;
                continue;
            }
            double currLabelWidth = labelCellWidths.nextDouble();
            if (!labelCellWidths.hasNext()) continue;
            maxLabelWidth = Math.max(maxLabelWidth, currLabelWidth);
        }
        return maxLabelWidth;
    }

    private static double maximumPortOrLabelWidth(NodeContext nodeContext, PortSide portSide) {
        double maxResult = 0.0;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            if (portContext.portLabelCell != null) {
                double labelWidth = portContext.portLabelCell.getMinimumWidth();
                maxResult = Math.max(maxResult, labelWidth);
            }
            maxResult = Math.max(maxResult, portContext.port.getSize().x);
        }
        return maxResult;
    }

    private static double portWidthPlusPortPortSpacing(NodeContext nodeContext, PortSide portSide, boolean includeMargins, boolean includeMarginsOfLastPort) {
        double result = 0.0;
        Iterator portContextIterator = nodeContext.portContexts.get((Object)portSide).iterator();
        while (portContextIterator.hasNext()) {
            PortContext portContext = (PortContext)portContextIterator.next();
            result += portContext.port.getSize().x;
            if (includeMargins && (portContextIterator.hasNext() || includeMarginsOfLastPort)) {
                result += portContext.portMargin.left + portContext.portMargin.right;
            }
            if (!portContextIterator.hasNext()) continue;
            result += nodeContext.portPortSpacing;
        }
        return result;
    }

    private static void setHorizontalPortMargins(NodeContext nodeContext, PortSide portSide, boolean centered, boolean excludeFirstPort, double uniformLabelWidth) {
        boolean exclude = excludeFirstPort;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            if (exclude) {
                exclude = false;
                continue;
            }
            double labelWidth = 0.0;
            if (uniformLabelWidth > 0.0) {
                labelWidth = uniformLabelWidth;
            } else if (portContext.portLabelCell != null) {
                labelWidth = portContext.portLabelCell.getMinimumWidth();
            }
            if (!(labelWidth > 0.0)) continue;
            if (centered) {
                double overhang;
                double portWidth = portContext.port.getSize().x;
                if (!(labelWidth > portWidth)) continue;
                portContext.portMargin.left = overhang = (labelWidth - portWidth) / 2.0;
                portContext.portMargin.right = overhang;
                continue;
            }
            portContext.portMargin.right = nodeContext.portLabelSpacing + labelWidth;
        }
    }
}

