/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.GraphConfigurator;
import org.eclipse.elk.alg.layered.IHierarchyAwareLayoutProcessor;
import org.eclipse.elk.alg.layered.components.ComponentsProcessor;
import org.eclipse.elk.alg.layered.compound.CompoundGraphPostprocessor;
import org.eclipse.elk.alg.layered.compound.CompoundGraphPreprocessor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.ContentAlignment;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.GreedySwitchType;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.testing.TestController;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.MapPropertyHolder;

public final class ElkLayered {
    private final GraphConfigurator graphConfigurator = new GraphConfigurator();
    private final ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private final CompoundGraphPreprocessor compoundGraphPreprocessor = new CompoundGraphPreprocessor();
    private final CompoundGraphPostprocessor compoundGraphPostprocessor = new CompoundGraphPostprocessor();
    private TestController testController = null;

    public void doLayout(LGraph lgraph, IElkProgressMonitor monitor) {
        IElkProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor(0);
        }
        theMonitor.begin("Layered layout", 1.0f);
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        List<LGraph> components = this.componentsProcessor.split(lgraph);
        if (components.size() == 1) {
            this.layout(components.get(0), theMonitor);
        } else {
            float compWork = 1.0f / (float)components.size();
            for (LGraph comp : components) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.layout(comp, theMonitor.subTask(compWork));
            }
        }
        this.componentsProcessor.combine(components, lgraph);
        this.resizeGraph(lgraph);
        theMonitor.done();
    }

    public void doCompoundLayout(LGraph lgraph, IElkProgressMonitor monitor) {
        IElkProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor(0);
        }
        theMonitor.begin("Layered layout", 2.0f);
        this.notifyProcessorReady(lgraph, this.compoundGraphPreprocessor);
        this.compoundGraphPreprocessor.process(lgraph, theMonitor.subTask(1.0f));
        this.notifyProcessorFinished(lgraph, this.compoundGraphPreprocessor);
        this.hierarchicalLayout(lgraph, theMonitor.subTask(1.0f));
        this.notifyProcessorReady(lgraph, this.compoundGraphPostprocessor);
        this.compoundGraphPostprocessor.process(lgraph, theMonitor.subTask(1.0f));
        this.notifyProcessorFinished(lgraph, this.compoundGraphPostprocessor);
        theMonitor.done();
    }

    private void hierarchicalLayout(LGraph lgraph, IElkProgressMonitor monitor) {
        Collection<LGraph> graphs = this.collectAllGraphsBottomUp(lgraph);
        this.reviewAndCorrectHierarchicalProcessors(lgraph, graphs);
        int work = 0;
        ArrayList<Pair<LGraph, Iterator<ILayoutProcessor<LGraph>>>> graphsAndAlgorithms = new ArrayList<Pair<LGraph, Iterator<ILayoutProcessor<LGraph>>>>();
        for (LGraph g : graphs) {
            this.graphConfigurator.prepareGraphForLayout(g);
            List processors = (List)g.getProperty(InternalProperties.PROCESSORS);
            work += processors.size();
            Iterator algorithm = processors.iterator();
            graphsAndAlgorithms.add((Pair<LGraph, Iterator<ILayoutProcessor<LGraph>>>)Pair.of((Object)g, algorithm));
        }
        monitor.begin("Recursive hierarchical layout", (float)work);
        Iterator<ILayoutProcessor<LGraph>> rootProcessors = this.getProcessorsForRootGraph(graphsAndAlgorithms);
        while (rootProcessors.hasNext()) {
            block2: for (Pair pair : graphsAndAlgorithms) {
                Iterator processors = (Iterator)pair.getSecond();
                LGraph graph = (LGraph)pair.getFirst();
                while (processors.hasNext()) {
                    ILayoutProcessor processor = (ILayoutProcessor)processors.next();
                    if (!(processor instanceof IHierarchyAwareLayoutProcessor)) {
                        this.notifyProcessorReady(graph, processor);
                        processor.process((Object)graph, monitor.subTask(1.0f));
                        this.notifyProcessorFinished(graph, processor);
                        continue;
                    }
                    if (!this.isRoot(graph)) continue block2;
                    this.notifyProcessorReady(graph, processor);
                    processor.process((Object)graph, monitor.subTask(1.0f));
                    this.notifyProcessorFinished(graph, processor);
                    continue block2;
                }
            }
        }
        monitor.done();
    }

    private Collection<LGraph> collectAllGraphsBottomUp(LGraph root) {
        ArrayDeque<LGraph> collectedGraphs = new ArrayDeque<LGraph>();
        ArrayDeque<LGraph> continueSearchingTheseGraphs = new ArrayDeque<LGraph>();
        collectedGraphs.push(root);
        continueSearchingTheseGraphs.push(root);
        while (!continueSearchingTheseGraphs.isEmpty()) {
            LGraph nextGraph = (LGraph)continueSearchingTheseGraphs.pop();
            for (LNode node : nextGraph.getLayerlessNodes()) {
                if (!this.hasNestedGraph(node)) continue;
                LGraph nestedGraph = node.getNestedGraph();
                collectedGraphs.push(nestedGraph);
                continueSearchingTheseGraphs.push(nestedGraph);
            }
        }
        return collectedGraphs;
    }

    private void reviewAndCorrectHierarchicalProcessors(LGraph root, Collection<LGraph> graphs) {
        CrossingMinimizationStrategy parentCms = (CrossingMinimizationStrategy)((Object)root.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY));
        if (parentCms != CrossingMinimizationStrategy.LAYER_SWEEP) {
            graphs.forEach(child -> {
                CrossingMinimizationStrategy childCms = (CrossingMinimizationStrategy)((Object)((Object)child.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY)));
                if (childCms == CrossingMinimizationStrategy.LAYER_SWEEP) {
                    child.setProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY, (Object)parentCms);
                }
            });
        }
        if (!GraphConfigurator.activateGreedySwitchFor(root)) {
            graphs.forEach(g -> {
                MapPropertyHolder mapPropertyHolder = g.setProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.OFF);
            });
        }
    }

    private Iterator<ILayoutProcessor<LGraph>> getProcessorsForRootGraph(List<Pair<LGraph, Iterator<ILayoutProcessor<LGraph>>>> graphsAndAlgorithms) {
        return (Iterator)graphsAndAlgorithms.get(graphsAndAlgorithms.size() - 1).getSecond();
    }

    private boolean isRoot(LGraph graph) {
        return graph.getParentNode() == null;
    }

    private boolean hasNestedGraph(LNode node) {
        return node.getNestedGraph() != null;
    }

    public TestExecutionState prepareLayoutTest(LGraph lgraph) {
        TestExecutionState state = new TestExecutionState();
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        state.graphs = this.componentsProcessor.split(lgraph);
        return state;
    }

    public boolean isLayoutTestFinished(TestExecutionState state) {
        LGraph graph = (LGraph)state.graphs.get(0);
        List algorithm = (List)graph.getProperty(InternalProperties.PROCESSORS);
        return algorithm != null && state.step >= algorithm.size();
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor<LGraph>> phase, boolean inclusive, TestExecutionState state) {
        List algorithm = (List)((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
        boolean phaseExists = false;
        ListIterator algorithmIterator = algorithm.listIterator(state.step);
        int phaseIndex = state.step;
        while (algorithmIterator.hasNext() && !phaseExists) {
            if (((ILayoutProcessor)algorithmIterator.next()).getClass().equals(phase)) {
                phaseExists = true;
                if (!inclusive) continue;
                ++phaseIndex;
                continue;
            }
            ++phaseIndex;
        }
        if (!phaseExists) {
            System.err.println("Given processor " + phase + " not part of the remaining algorithm.");
        }
        algorithmIterator = algorithm.listIterator(state.step);
        while (state.step < phaseIndex) {
            this.layoutTest(state.graphs, (ILayoutProcessor<LGraph>)((ILayoutProcessor)algorithmIterator.next()));
            TestExecutionState testExecutionState = state;
            testExecutionState.step = testExecutionState.step + 1;
        }
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor<LGraph>> phase, TestExecutionState state) {
        this.runLayoutTestUntil(phase, true, state);
    }

    public void runLayoutTestStep(TestExecutionState state) {
        if (this.isLayoutTestFinished(state)) {
            throw new IllegalStateException("Current layout test run has finished.");
        }
        List algorithm = (List)((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
        this.layoutTest(state.graphs, (ILayoutProcessor<LGraph>)((ILayoutProcessor)algorithm.get(state.step)));
        TestExecutionState testExecutionState = state;
        testExecutionState.step = testExecutionState.step + 1;
    }

    public List<ILayoutProcessor<LGraph>> getLayoutTestConfiguration(TestExecutionState state) {
        return (List)((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
    }

    public void setTestController(TestController testController) {
        this.testController = testController;
    }

    private void notifyProcessorReady(LGraph lgraph, ILayoutProcessor<?> processor) {
        if (this.testController != null) {
            this.testController.notifyProcessorReady((Object)lgraph, processor);
            if (this.isRoot(lgraph)) {
                this.testController.notifyRootProcessorReady((Object)lgraph, processor);
            }
        }
    }

    private void notifyProcessorFinished(LGraph lgraph, ILayoutProcessor<?> processor) {
        if (this.testController != null) {
            this.testController.notifyProcessorFinished((Object)lgraph, processor);
            if (this.isRoot(lgraph)) {
                this.testController.notifyRootProcessorFinished((Object)lgraph, processor);
            }
        }
    }

    private void layout(LGraph lgraph, IElkProgressMonitor monitor) {
        boolean monitorStarted = monitor.isRunning();
        if (!monitorStarted) {
            monitor.begin("Component Layout", 1.0f);
        }
        List algorithm = (List)lgraph.getProperty(InternalProperties.PROCESSORS);
        float monitorProgress = 1.0f / (float)algorithm.size();
        if (((Boolean)lgraph.getProperty(LayeredOptions.DEBUG_MODE)).booleanValue()) {
            System.out.println("ELK Layered uses the following " + algorithm.size() + " modules:");
            int slot = 0;
            for (ILayoutProcessor processor : algorithm) {
                String gwtDoesntSupportPrintf = String.valueOf(slot < 10 ? "0" : "") + slot++;
                System.out.println("   Slot " + gwtDoesntSupportPrintf + ": " + processor.getClass().getName());
            }
            int slotIndex = 0;
            for (ILayoutProcessor processor : algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                DebugUtil.writeDebugGraph(lgraph, slotIndex++, processor.getClass().getSimpleName());
                this.notifyProcessorReady(lgraph, processor);
                processor.process((Object)lgraph, monitor.subTask(monitorProgress));
                this.notifyProcessorFinished(lgraph, processor);
            }
            DebugUtil.writeDebugGraph(lgraph, slotIndex, "finished");
        } else {
            for (ILayoutProcessor processor : algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.notifyProcessorReady(lgraph, processor);
                processor.process((Object)lgraph, monitor.subTask(monitorProgress));
                this.notifyProcessorFinished(lgraph, processor);
            }
        }
        for (Layer layer : lgraph) {
            lgraph.getLayerlessNodes().addAll(layer.getNodes());
            layer.getNodes().clear();
        }
        for (LNode node : lgraph.getLayerlessNodes()) {
            node.setLayer(null);
        }
        lgraph.getLayers().clear();
        if (!monitorStarted) {
            monitor.done();
        }
    }

    private void layoutTest(List<LGraph> lgraphs, ILayoutProcessor<LGraph> processor) {
        for (LGraph lgraph : lgraphs) {
            this.notifyProcessorReady(lgraph, processor);
            processor.process((Object)lgraph, (IElkProgressMonitor)new BasicProgressMonitor());
            this.notifyProcessorFinished(lgraph, processor);
        }
    }

    private void resizeGraph(LGraph lgraph) {
        Set sizeConstraint = (Set)lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        Set sizeOptions = (Set)lgraph.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        KVector calculatedSize = lgraph.getActualSize();
        KVector adjustedSize = new KVector(calculatedSize);
        if (sizeConstraint.contains(SizeConstraint.MINIMUM_SIZE)) {
            KVector minSize = (KVector)lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
            if (sizeOptions.contains(SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minSize.x <= 0.0) {
                    minSize.x = 20.0;
                }
                if (minSize.y <= 0.0) {
                    minSize.y = 20.0;
                }
            }
            adjustedSize.x = Math.max(calculatedSize.x, minSize.x);
            adjustedSize.y = Math.max(calculatedSize.y, minSize.y);
        }
        this.resizeGraphNoReallyIMeanIt(lgraph, calculatedSize, adjustedSize);
    }

    private void resizeGraphNoReallyIMeanIt(LGraph lgraph, KVector oldSize, KVector newSize) {
        Set contentAlignment = (Set)lgraph.getProperty(LayeredOptions.CONTENT_ALIGNMENT);
        if (newSize.x > oldSize.x) {
            if (contentAlignment.contains((Object)ContentAlignment.H_CENTER)) {
                lgraph.getOffset().x += (newSize.x - oldSize.x) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.H_RIGHT)) {
                lgraph.getOffset().x += newSize.x - oldSize.x;
            }
        }
        if (newSize.y > oldSize.y) {
            if (contentAlignment.contains((Object)ContentAlignment.V_CENTER)) {
                lgraph.getOffset().y += (newSize.y - oldSize.y) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.V_BOTTOM)) {
                lgraph.getOffset().y += newSize.y - oldSize.y;
            }
        }
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS) && (newSize.x > oldSize.x || newSize.y > oldSize.y)) {
            for (LNode node : lgraph.getLayerlessNodes()) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (extPortSide == PortSide.EAST) {
                    node.getPosition().x += newSize.x - oldSize.x;
                    continue;
                }
                if (extPortSide != PortSide.SOUTH) continue;
                node.getPosition().y += newSize.y - oldSize.y;
            }
        }
        LPadding lPadding = lgraph.getPadding();
        lgraph.getSize().x = newSize.x - lPadding.left - lPadding.right;
        lgraph.getSize().y = newSize.y - lPadding.top - lPadding.bottom;
    }

    public static class TestExecutionState {
        private List<LGraph> graphs;
        private int step;

        public List<LGraph> getGraphs() {
            return this.graphs;
        }

        public int getStep() {
            return this.step;
        }
    }
}

