/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.options;

import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p2layers.CoffmanGrahamLayerer;
import org.eclipse.elk.alg.layered.p2layers.InteractiveLayerer;
import org.eclipse.elk.alg.layered.p2layers.LongestPathLayerer;
import org.eclipse.elk.alg.layered.p2layers.MinWidthLayerer;
import org.eclipse.elk.alg.layered.p2layers.NetworkSimplexLayerer;
import org.eclipse.elk.alg.layered.p2layers.StretchWidthLayerer;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;

public enum LayeringStrategy implements ILayoutPhaseFactory<LayeredPhases, LGraph>
{
    NETWORK_SIMPLEX,
    LONGEST_PATH,
    COFFMAN_GRAHAM,
    INTERACTIVE,
    STRETCH_WIDTH,
    MIN_WIDTH;


    public ILayoutPhase<LayeredPhases, LGraph> create() {
        switch (this) {
            case NETWORK_SIMPLEX: {
                return new NetworkSimplexLayerer();
            }
            case LONGEST_PATH: {
                return new LongestPathLayerer();
            }
            case COFFMAN_GRAHAM: {
                return new CoffmanGrahamLayerer();
            }
            case INTERACTIVE: {
                return new InteractiveLayerer();
            }
            case STRETCH_WIDTH: {
                return new StretchWidthLayerer();
            }
            case MIN_WIDTH: {
                return new MinWidthLayerer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layerer " + this.toString());
    }
}

