/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Set;
import org.eclipse.elk.alg.common.nodespacing.NodeDimensionCalculation;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphAdapters;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.adapters.GraphAdapters;

public final class LabelAndNodeSizeProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Node and Port Label Placement and Node Sizing", 1.0f);
        NodeDimensionCalculation.calculateLabelAndNodeSizes((GraphAdapters.GraphAdapter)LGraphAdapters.adapt(layeredGraph, true, true, node -> node.getType() == LNode.NodeType.NORMAL || node.getType() == LNode.NodeType.BIG_NODE));
        if (((Set)layeredGraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            PortLabelPlacement portLabelPlacement = (PortLabelPlacement)layeredGraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT);
            boolean placeNextToPort = (Boolean)layeredGraph.getProperty(LayeredOptions.PORT_LABELS_NEXT_TO_PORT_IF_POSSIBLE);
            boolean treatAsGroup = (Boolean)layeredGraph.getProperty(LayeredOptions.PORT_LABELS_TREAT_AS_GROUP);
            for (Layer layer : layeredGraph.getLayers()) {
                layer.getNodes().stream().filter(node -> node.getType() == LNode.NodeType.EXTERNAL_PORT).forEach(dummy -> this.placeExternalPortDummyLabels((LNode)((Object)dummy), portLabelPlacement, placeNextToPort, treatAsGroup));
            }
        }
        monitor.done();
    }

    private void placeExternalPortDummyLabels(LNode dummy, PortLabelPlacement graphPortLabelPlacement, boolean placeNextToPortIfPossible, boolean treatAsGroup) {
        double labelHeight;
        double labelPortSpacing = (Double)dummy.getProperty(LayeredOptions.SPACING_LABEL_PORT);
        double labelLabelSpacing = (Double)dummy.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
        KVector dummySize = dummy.getSize();
        LPort dummyPort = dummy.getPorts().get(0);
        KVector dummyPortPos = dummyPort.getPosition();
        ElkRectangle portLabelBox = this.computePortLabelBox(dummyPort, labelLabelSpacing);
        if (portLabelBox == null) {
            return;
        }
        if (graphPortLabelPlacement == PortLabelPlacement.INSIDE) {
            switch ((PortSide)dummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case NORTH: {
                    portLabelBox.x = (dummySize.x - portLabelBox.width) / 2.0 - dummyPortPos.x;
                    portLabelBox.y = labelPortSpacing;
                    break;
                }
                case SOUTH: {
                    portLabelBox.x = (dummySize.x - portLabelBox.width) / 2.0 - dummyPortPos.x;
                    portLabelBox.y = -labelPortSpacing - portLabelBox.height;
                    break;
                }
                case EAST: {
                    if (this.labelNextToPort(dummyPort, true, placeNextToPortIfPossible)) {
                        labelHeight = treatAsGroup ? portLabelBox.height : dummyPort.getLabels().get((int)0).getSize().y;
                        portLabelBox.y = (dummySize.y - labelHeight) / 2.0 - dummyPortPos.y;
                    } else {
                        portLabelBox.y = dummySize.y + labelPortSpacing - dummyPortPos.y;
                    }
                    portLabelBox.x = -labelPortSpacing - portLabelBox.width;
                    break;
                }
                case WEST: {
                    if (this.labelNextToPort(dummyPort, true, placeNextToPortIfPossible)) {
                        labelHeight = treatAsGroup ? portLabelBox.height : dummyPort.getLabels().get((int)0).getSize().y;
                        portLabelBox.y = (dummySize.y - labelHeight) / 2.0 - dummyPortPos.y;
                    } else {
                        portLabelBox.y = dummySize.y + labelPortSpacing - dummyPortPos.y;
                    }
                    portLabelBox.x = labelPortSpacing;
                }
            }
        } else if (graphPortLabelPlacement == PortLabelPlacement.OUTSIDE) {
            switch ((PortSide)dummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case NORTH: 
                case SOUTH: {
                    portLabelBox.x = dummyPortPos.x + labelPortSpacing;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (this.labelNextToPort(dummyPort, false, placeNextToPortIfPossible)) {
                        labelHeight = treatAsGroup ? portLabelBox.height : dummyPort.getLabels().get((int)0).getSize().y;
                        portLabelBox.y = (dummySize.y - labelHeight) / 2.0 - dummyPortPos.y;
                        break;
                    }
                    portLabelBox.y = dummyPortPos.y + labelPortSpacing;
                }
            }
        }
        double currentY = portLabelBox.y;
        for (LLabel label : dummyPort.getLabels()) {
            KVector labelPos = label.getPosition();
            labelPos.x = portLabelBox.x;
            labelPos.y = currentY;
            currentY += label.getSize().y + labelLabelSpacing;
        }
    }

    private ElkRectangle computePortLabelBox(LPort dummyPort, double labelLabelSpacing) {
        if (dummyPort.getLabels().isEmpty()) {
            return null;
        }
        ElkRectangle result = new ElkRectangle();
        for (LLabel label : dummyPort.getLabels()) {
            KVector labelSize = label.getSize();
            result.width = Math.max(result.width, labelSize.x);
            result.height += labelSize.y;
        }
        result.height += (double)(dummyPort.getLabels().size() - 1) * labelLabelSpacing;
        return result;
    }

    private boolean labelNextToPort(LPort dummyPort, boolean insideLabels, boolean placeNextToPortIfPossible) {
        if (!placeNextToPortIfPossible) {
            return false;
        }
        if (insideLabels) {
            return dummyPort.getIncomingEdges().isEmpty() && dummyPort.getOutgoingEdges().isEmpty();
        }
        return !dummyPort.isConnectedToExternalNodes();
    }
}

