/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.BlockRow;
import org.eclipse.elk.alg.rectpacking.util.BlockStack;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.graph.ElkNode;

public class Block {
    private double smallestRectWidth = Double.POSITIVE_INFINITY;
    private double minWidth;
    private double width;
    private double minHeight;
    private double smallestRectHeight = Double.POSITIVE_INFINITY;
    private double averageHeight;
    private double maxHeight;
    private double height;
    private final List<ElkNode> children = new ArrayList<ElkNode>();
    private final List<BlockRow> rows = new ArrayList<BlockRow>();
    private double x;
    private double y;
    private RectRow parentRow;
    private BlockStack stack;
    private double nodeNodeSpacing;
    private boolean fixed;
    private boolean positionFixed;

    public Block(double xCoord, double yCoord, RectRow parentRow, double nodeNodeSpacing) {
        this.nodeNodeSpacing = nodeNodeSpacing;
        this.parentRow = parentRow;
        this.x = xCoord;
        this.y = yCoord;
        this.width = 0.0;
        this.height = 0.0;
    }

    public void addChild(ElkNode rect) {
        if (this.rows.isEmpty()) {
            this.rows.add(new BlockRow(this.x, this.y, this.nodeNodeSpacing));
        }
        this.children.add(rect);
        this.rows.get(this.rows.size() - 1).addRectangle(rect);
        this.adjustSizeAdd(rect);
    }

    public void addChildInNewRow(ElkNode rect) {
        this.children.add(rect);
        BlockRow lastRow = this.getLastRow();
        this.rows.add(new BlockRow(this.x, lastRow.getY() + lastRow.getHeight(), this.nodeNodeSpacing));
        this.getLastRow().addRectangle(rect);
        this.adjustSizeAdd(rect);
    }

    public void removeChild(ElkNode rect) {
        this.children.remove(rect);
        for (BlockRow row : this.rows) {
            if (!row.getNodes().contains(rect)) continue;
            row.removeRectangle(rect, true);
            if (!row.getNodes().isEmpty()) break;
            this.rows.remove(row);
            break;
        }
        this.adjustSizeAfterRemove();
    }

    public void setLocation(double xCoord, double yCoord) {
        this.adjustChildrensXandY(xCoord - this.x, yCoord - this.y);
        for (BlockRow row : this.rows) {
            row.setX(row.getX() + xCoord - this.x);
            row.setY(row.getY() + yCoord - this.y);
        }
        this.x = xCoord;
        this.y = yCoord;
    }

    private void adjustChildrensXandY(double xChange, double yChange) {
        for (ElkNode rect : this.children) {
            rect.setLocation(rect.getX() + xChange, rect.getY() + yChange);
        }
    }

    private void adjustSizeAdd(ElkNode rect) {
        double widthOflastRow = this.getLastRow().getWidth();
        this.smallestRectWidth = Math.min(this.smallestRectWidth, rect.getWidth() + this.nodeNodeSpacing);
        this.width = Math.max(this.width, widthOflastRow);
        this.minWidth = Math.max(this.minWidth, rect.getWidth() + this.nodeNodeSpacing);
        this.smallestRectHeight = Math.min(this.smallestRectHeight, rect.getHeight() + this.nodeNodeSpacing);
        this.maxHeight += rect.getHeight() + this.nodeNodeSpacing;
        this.minHeight = Math.max(this.minHeight, rect.getHeight() + this.nodeNodeSpacing);
        double totalHeight = 0.0;
        for (BlockRow row : this.rows) {
            totalHeight += row.getHeight();
        }
        this.height = totalHeight;
        this.averageHeight = this.maxHeight / (double)this.children.size();
        this.parentRow.notifyAboutNodeChange();
    }

    public double getWidthForTargetHeight(double height) {
        if (this.maxHeight <= height) {
            return this.minWidth;
        }
        if (this.placeRectsIn(this.minWidth, height, false)) {
            return this.minWidth;
        }
        double upperBound = this.width;
        double lowerBound = this.minWidth;
        double viableWidth = this.width;
        double newWidth = (upperBound - lowerBound) / 2.0 + lowerBound;
        while (lowerBound + 1.0 < upperBound) {
            if (this.placeRectsIn(newWidth, height, false)) {
                viableWidth = newWidth;
                upperBound = newWidth;
            } else {
                lowerBound = newWidth;
            }
            newWidth = (upperBound - lowerBound) / 2.0 + lowerBound;
        }
        return viableWidth;
    }

    public double getHeightForTargetWidth(double width) {
        ElkRectangle bounds = this.placeRectsIn(width, false);
        return bounds.height;
    }

    private ElkRectangle placeRectsIn(double width, boolean placeRects) {
        double currentX = 0.0;
        double currentY = this.y;
        double currentWidth = 0.0;
        double currentHeight = 0.0;
        double maxHeightInRow = 0.0;
        double widthInRow = 0.0;
        int row = 0;
        if (placeRects) {
            this.rows.clear();
            this.rows.add(new BlockRow(this.x, this.y, this.nodeNodeSpacing));
        }
        for (ElkNode rect : this.children) {
            if (currentX + rect.getWidth() + this.nodeNodeSpacing > width && maxHeightInRow > 0.0) {
                currentX = 0.0;
                currentY += maxHeightInRow;
                currentWidth = Math.max(currentWidth, widthInRow);
                currentHeight += maxHeightInRow;
                maxHeightInRow = 0.0;
                widthInRow = 0.0;
                if (placeRects) {
                    ++row;
                    this.rows.add(new BlockRow(this.x, currentY, this.nodeNodeSpacing));
                }
            }
            widthInRow += rect.getWidth() + this.nodeNodeSpacing;
            maxHeightInRow = Math.max(maxHeightInRow, rect.getHeight() + this.nodeNodeSpacing);
            if (placeRects) {
                this.rows.get(row).addRectangle(rect);
            }
            currentX += rect.getWidth() + this.nodeNodeSpacing;
        }
        currentWidth = Math.max(currentWidth, widthInRow);
        currentHeight += maxHeightInRow;
        if (placeRects) {
            this.width = currentWidth;
            this.height = currentHeight;
            this.parentRow.notifyAboutNodeChange();
        }
        return new ElkRectangle(this.x, this.y, currentWidth, currentHeight);
    }

    private boolean placeRectsIn(double width, double height, boolean placeRects) {
        ElkRectangle bounds = this.placeRectsIn(width, placeRects);
        return bounds.width <= width && bounds.height <= height;
    }

    public boolean placeRectsIn(double width, double height) {
        return this.placeRectsIn(width, height, true);
    }

    public void placeRectsIn(double width) {
        this.placeRectsIn(width, true);
    }

    private void adjustSizeAfterRemove() {
        double newWidth = 0.0;
        double newHeight = 0.0;
        LinkedList<BlockRow> rowsToDelete = new LinkedList<BlockRow>();
        for (BlockRow row : this.rows) {
            if (row.getNodes().isEmpty()) {
                rowsToDelete.add(row);
                continue;
            }
            newWidth = Math.max(newWidth, row.getWidth());
            newHeight += row.getHeight();
        }
        this.rows.removeAll(rowsToDelete);
        this.height = newHeight;
        this.width = newWidth;
        this.minWidth = 0.0;
        this.minHeight = 0.0;
        this.maxHeight = 0.0;
        this.smallestRectHeight = Double.POSITIVE_INFINITY;
        this.smallestRectWidth = Double.POSITIVE_INFINITY;
        for (ElkNode rect : this.children) {
            this.smallestRectWidth = Math.min(this.smallestRectWidth, rect.getWidth() + this.nodeNodeSpacing);
            this.minWidth = Math.max(this.minWidth, rect.getWidth() + this.nodeNodeSpacing);
            this.minHeight = Math.max(this.minHeight, rect.getHeight() + this.nodeNodeSpacing);
            this.smallestRectHeight = Math.min(this.smallestRectHeight, rect.getHeight() + this.nodeNodeSpacing);
            this.maxHeight += rect.getHeight() + this.nodeNodeSpacing;
        }
        this.averageHeight = this.maxHeight / (double)this.children.size();
        this.parentRow.notifyAboutNodeChange();
    }

    public void expand(double additionalWidthPerBlock, double additionalHeightForBlock) {
        double widthForRow = this.width + additionalWidthPerBlock;
        this.width += additionalWidthPerBlock;
        this.height += additionalHeightForBlock;
        double additionalHeightForRow = additionalHeightForBlock / (double)this.rows.size();
        int index = 0;
        for (BlockRow row : this.rows) {
            row.expand(widthForRow, additionalHeightForRow, index);
            ++index;
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public List<ElkNode> getChildren() {
        return this.children;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public RectRow getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(RectRow parentRow) {
        this.parentRow = parentRow;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public double getSmallestRectHeight() {
        return this.smallestRectHeight;
    }

    public double getAverageHeight() {
        return this.averageHeight;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isPositionFixed() {
        return this.positionFixed;
    }

    public void setPositionFixed(boolean positionFixed) {
        this.positionFixed = positionFixed;
    }

    public List<BlockRow> getRows() {
        return this.rows;
    }

    public double getLastRowNewX() {
        BlockRow lastRow = this.getLastRow();
        return lastRow.getX() + lastRow.getWidth();
    }

    public double getLastRowY() {
        BlockRow lastRow = this.getLastRow();
        return lastRow.getY();
    }

    public BlockRow getLastRow() {
        return this.rows.get(this.rows.size() - 1);
    }

    public BlockStack getStack() {
        return this.stack;
    }

    public void setStack(BlockStack stack) {
        this.stack = stack;
    }

    public double getSmallestRectWidth() {
        return this.smallestRectWidth;
    }

    public void setSmallestRectWidth(double smallestRectWidth) {
        this.smallestRectWidth = smallestRectWidth;
    }
}

