/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.alg.layered.p3order.AbstractBarycenterPortDistributor;
import org.eclipse.elk.alg.layered.p3order.ForsterConstraintResolver;
import org.eclipse.elk.alg.layered.p3order.ICrossingMinimizationHeuristic;
import org.eclipse.elk.alg.layered.p3order.ModelOrderBarycenterHeuristic;

public class BarycenterHeuristic
implements ICrossingMinimizationHeuristic {
    protected float[] portRanks;
    protected final Random random;
    protected ForsterConstraintResolver constraintResolver;
    protected BarycenterState[][] barycenterState;
    protected final AbstractBarycenterPortDistributor portDistributor;
    private static final float RANDOM_AMOUNT = 0.07f;
    protected Comparator<LNode> barycenterStateComparator = (n1, n2) -> {
        BarycenterState s1 = this.stateOf((LNode)((Object)n1));
        BarycenterState s2 = this.stateOf((LNode)((Object)n2));
        if (s1.barycenter != null && s2.barycenter != null) {
            return s1.barycenter.compareTo(s2.barycenter);
        }
        if (s1.barycenter != null) {
            return -1;
        }
        if (s2.barycenter != null) {
            return 1;
        }
        return 0;
    };

    public BarycenterHeuristic(ForsterConstraintResolver constraintResolver, Random random, AbstractBarycenterPortDistributor portDistributor, LNode[][] graph) {
        this.constraintResolver = constraintResolver;
        this.random = random;
        this.portDistributor = portDistributor;
    }

    public void minimizeCrossings(List<LNode> layer, boolean preOrdered, boolean randomize, boolean forward) {
        if (randomize) {
            this.randomizeBarycenters(layer);
        } else {
            this.calculateBarycenters(layer, forward);
            this.fillInUnknownBarycenters(layer, preOrdered);
        }
        if (layer.size() > 1) {
            if (((Boolean)layer.get(0).getGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER)).booleanValue()) {
                ModelOrderBarycenterHeuristic.insertionSort(layer, this.barycenterStateComparator, (ModelOrderBarycenterHeuristic)this);
            } else {
                Collections.sort(layer, this.barycenterStateComparator);
            }
            this.constraintResolver.processConstraints(layer);
        }
    }

    protected void randomizeBarycenters(List<LNode> nodes) {
        for (LNode node : nodes) {
            this.stateOf((LNode)node).barycenter = this.random.nextDouble();
            this.stateOf((LNode)node).summedWeight = this.stateOf((LNode)node).barycenter;
            this.stateOf((LNode)node).degree = 1;
        }
    }

    protected void fillInUnknownBarycenters(List<LNode> nodes, boolean preOrdered) {
        if (preOrdered) {
            double lastValue = -1.0;
            ListIterator<LNode> nodesIterator = nodes.listIterator();
            while (nodesIterator.hasNext()) {
                LNode node = nodesIterator.next();
                Double value = this.stateOf((LNode)node).barycenter;
                if (value == null) {
                    double nextValue = lastValue + 1.0;
                    ListIterator<LNode> nextNodeIterator = nodes.listIterator(nodesIterator.nextIndex());
                    while (nextNodeIterator.hasNext()) {
                        Double x = this.stateOf((LNode)nextNodeIterator.next()).barycenter;
                        if (x == null) continue;
                        nextValue = x;
                        break;
                    }
                    this.stateOf((LNode)node).barycenter = value = Double.valueOf((lastValue + nextValue) / 2.0);
                    this.stateOf((LNode)node).summedWeight = value;
                    this.stateOf((LNode)node).degree = 1;
                }
                lastValue = value;
            }
        } else {
            double maxBary = 0.0;
            for (LNode node : nodes) {
                if (this.stateOf((LNode)node).barycenter == null) continue;
                maxBary = Math.max(maxBary, this.stateOf((LNode)node).barycenter);
            }
            maxBary += 2.0;
            for (LNode node : nodes) {
                if (this.stateOf((LNode)node).barycenter != null) continue;
                double value = (double)this.random.nextFloat() * maxBary - 1.0;
                this.stateOf((LNode)node).barycenter = value;
                this.stateOf((LNode)node).summedWeight = value;
                this.stateOf((LNode)node).degree = 1;
            }
        }
    }

    protected void calculateBarycenters(List<LNode> nodes, boolean forward) {
        for (LNode node : nodes) {
            this.stateOf((LNode)node).visited = false;
        }
        for (LNode node : nodes) {
            this.calculateBarycenter(node, forward);
        }
    }

    private void calculateBarycenter(LNode node, boolean forward) {
        if (this.stateOf((LNode)node).visited) {
            return;
        }
        this.stateOf((LNode)node).visited = true;
        this.stateOf((LNode)node).degree = 0;
        this.stateOf((LNode)node).summedWeight = 0.0;
        this.stateOf((LNode)node).barycenter = null;
        for (LPort freePort : node.getPorts()) {
            Iterable<LPort> portIterable = forward ? freePort.getPredecessorPorts() : freePort.getSuccessorPorts();
            for (LPort fixedPort : portIterable) {
                LNode fixedNode = fixedPort.getNode();
                if (fixedNode.getLayer() == node.getLayer()) {
                    if (fixedNode == node) continue;
                    this.calculateBarycenter(fixedNode, forward);
                    this.stateOf((LNode)node).degree += this.stateOf((LNode)fixedNode).degree;
                    this.stateOf((LNode)node).summedWeight += this.stateOf((LNode)fixedNode).summedWeight;
                    continue;
                }
                this.stateOf((LNode)node).summedWeight += (double)this.portRanks[fixedPort.id];
                ++this.stateOf((LNode)node).degree;
            }
        }
        List barycenterAssociates = (List)node.getProperty(InternalProperties.BARYCENTER_ASSOCIATES);
        if (barycenterAssociates != null) {
            for (LNode associate : barycenterAssociates) {
                if (node.getLayer() != associate.getLayer()) continue;
                this.calculateBarycenter(associate, forward);
                this.stateOf((LNode)node).degree += this.stateOf((LNode)associate).degree;
                this.stateOf((LNode)node).summedWeight += this.stateOf((LNode)associate).summedWeight;
            }
        }
        if (this.stateOf((LNode)node).degree > 0) {
            this.stateOf((LNode)node).summedWeight += (double)(this.random.nextFloat() * 0.07f - 0.035f);
            this.stateOf((LNode)node).barycenter = this.stateOf((LNode)node).summedWeight / (double)this.stateOf((LNode)node).degree;
        }
    }

    protected BarycenterState stateOf(LNode node) {
        return this.barycenterState[node.getLayer().id][node.id];
    }

    @Override
    public boolean minimizeCrossings(LNode[][] order, int freeLayerIndex, boolean forwardSweep, boolean isFirstSweep) {
        if (!this.isFirstLayer(order, freeLayerIndex, forwardSweep)) {
            LNode[] fixedLayer = order[freeLayerIndex - this.changeIndex(forwardSweep)];
            this.portDistributor.calculatePortRanks(fixedLayer, this.portTypeFor(forwardSweep));
        }
        LNode firstNodeInLayer = order[freeLayerIndex][0];
        boolean preOrdered = !isFirstSweep || this.isExternalPortDummy(firstNodeInLayer);
        ArrayList nodes = Lists.newArrayList((Object[])order[freeLayerIndex]);
        this.minimizeCrossings(nodes, preOrdered, false, forwardSweep);
        int index = 0;
        for (LNode nodeGroup : nodes) {
            order[freeLayerIndex][index++] = nodeGroup;
        }
        return false;
    }

    @Override
    public boolean setFirstLayerOrder(LNode[][] order, boolean isForwardSweep) {
        int startIndex = this.startIndex(isForwardSweep, order.length);
        ArrayList nodes = Lists.newArrayList((Object[])order[startIndex]);
        this.minimizeCrossings(nodes, false, true, isForwardSweep);
        int index = 0;
        for (LNode nodeGroup : nodes) {
            order[startIndex][index++] = nodeGroup;
        }
        return false;
    }

    private boolean isExternalPortDummy(LNode firstNode) {
        return firstNode.getType() == LNode.NodeType.EXTERNAL_PORT;
    }

    private int changeIndex(boolean dir) {
        return dir ? 1 : -1;
    }

    private PortType portTypeFor(boolean direction) {
        return direction ? PortType.OUTPUT : PortType.INPUT;
    }

    private int startIndex(boolean dir, int length) {
        return dir ? 0 : Math.max(0, length - 1);
    }

    private boolean isFirstLayer(LNode[][] nodeOrder, int currentIndex, boolean forwardSweep) {
        return currentIndex == this.startIndex(forwardSweep, nodeOrder.length);
    }

    @Override
    public boolean alwaysImproves() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void initAfterTraversal() {
        this.barycenterState = this.constraintResolver.getBarycenterStates();
        this.portRanks = this.portDistributor.getPortRanks();
    }

    @Override
    public void initAtLayerLevel(int l, LNode[][] nodeOrder) {
        nodeOrder[l][0].getLayer().id = l;
    }

    public static final class BarycenterState {
        public LNode node;
        public double summedWeight;
        public int degree;
        public Double barycenter;
        public boolean visited;

        public BarycenterState(LNode node) {
            this.node = node;
        }

        public String toString() {
            return "BarycenterState [node=" + (Object)((Object)this.node) + ", summedWeight=" + this.summedWeight + ", degree=" + this.degree + ", barycenter=" + this.barycenter + ", visited=" + this.visited + "]";
        }
    }
}

