/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data;

import java.util.Iterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonGenericParser {
    public String isCollection(String name) {
        return null;
    }

    public Node parse(JSONObject json) {
        Node tree = new Node("root");
        tree.setPackType(Leaf.PACK_TYPE_XPACK);
        for (Object key : json.keySet()) {
            this.parseRecursive(key.toString(), json.get(key), tree);
        }
        return tree;
    }

    private void parseRecursive(String name, Object value, Node parent) {
        if (value instanceof JSONObject) {
            boolean canBeCollection = true;
            for (Object childKey : ((JSONObject)value).keySet()) {
                Object childValue = ((JSONObject)value).get(childKey);
                if (childValue instanceof JSONObject) continue;
                canBeCollection = false;
                break;
            }
            if (canBeCollection) {
                Node node;
                String type = this.isCollection(name);
                if (type != null) {
                    if (type.equals(name)) {
                        node = parent;
                    } else {
                        node = Node.addNewChild(parent, name);
                        node.setPackType(Leaf.PACK_TYPE_XPACK);
                    }
                    for (Iterator key : ((JSONObject)value).keySet()) {
                        JSONObject child = (JSONObject)((JSONObject)value).get(key);
                        child.put((Object)"$KEY", key);
                        this.parseRecursive(type, child, node);
                    }
                } else {
                    node = Node.addNewChild(parent, name);
                    node.setPackType(Leaf.PACK_TYPE_XPACK);
                    for (Iterator key : ((JSONObject)value).keySet()) {
                        this.parseRecursive(key.toString(), ((JSONObject)value).get(key), node);
                    }
                }
            } else {
                Node node = Node.addNewChild(parent, name);
                node.setPackType(Leaf.PACK_TYPE_XPACK);
                for (Object key : ((JSONObject)value).keySet()) {
                    this.parseRecursive(key.toString(), ((JSONObject)value).get(key), node);
                }
            }
        } else if (value instanceof JSONArray) {
            Node node = Node.addNewChild(parent, name);
            node.setPackType(Leaf.PACK_TYPE_XPACK);
            for (Object arrValue : (JSONArray)value) {
                if (arrValue instanceof JSONObject) {
                    this.parseRecursive(name, (JSONObject)arrValue, node);
                    continue;
                }
                if (!(arrValue instanceof String)) continue;
                Node subNode = Node.addNewChild(node, "$ARRAY_ELEMENT");
                subNode.setPackType(Leaf.PACK_TYPE_XPACK);
                subNode.putProperty("$VALUE", (String)arrValue);
            }
        } else if ("description".equals(name)) {
            parent.setDescription(value.toString());
        } else if (value == null) {
            parent.putNonEmptyProperty(name, "null");
        } else {
            parent.putNonEmptyProperty(name, value.toString());
        }
    }
}

