/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.data.IAvailableSupport;
import org.eclipse.embedcdt.packs.core.data.IPacksDataManager;
import org.eclipse.embedcdt.packs.core.data.IPacksDataManagerFactory;

public class PacksDataManagerFactoryProxy
implements IPacksDataManagerFactory,
IAvailableSupport {
    private static final String FACTORY_ELEMENT = "factory";
    private static final String CLASS_ATTRIBUTE = "class";
    public static final String EXTENSION_POINT_NAME = "data";
    public static final String EXTENSION_POINT_ID = "org.eclipse.embedcdt.packs.core.data";
    private static PacksDataManagerFactoryProxy fgInstance;
    private IPacksDataManager fDataManager = null;

    public static PacksDataManagerFactoryProxy getInstance() {
        if (fgInstance == null) {
            fgInstance = new PacksDataManagerFactoryProxy();
        }
        return fgInstance;
    }

    @Override
    public IPacksDataManager createDataManager() {
        IExtensionPoint extensionPoint;
        if (this.fDataManager != null) {
            return this.fDataManager;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DataManagerFactoryProxy.createDataManager()");
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID)) == null) {
            Activator.log((String)"Extension point org.eclipse.embedcdt.packs.core.data not found");
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length != 1) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("No single org.eclipse.embedcdt.packs.core.data extension point");
            }
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        IConfigurationElement configElement = configElements[0];
        if (!FACTORY_ELEMENT.equals(configElement.getName())) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("no <factory> element");
            }
            return null;
        }
        try {
            Object obj = configElement.createExecutableExtension(CLASS_ATTRIBUTE);
            if (obj instanceof IPacksDataManagerFactory) {
                IPacksDataManagerFactory factory = (IPacksDataManagerFactory)obj;
                this.fDataManager = factory.createDataManager();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("DataManagerFactoryProxy.createDataManager() completed");
                }
                return this.fDataManager;
            }
            return null;
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
            return null;
        }
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public void dispose() {
    }
}

