package simplewebmodel.smells;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.IndexPage;
import simplewebmodel.Link;
import simplewebmodel.StaticPage;
import simplewebmodel.WebModel;

public class MissingLink implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		
		
		List<IndexPage> indexPages = getAllIndexPages(root);
		StaticPage startPage = ((WebModel) root).getHypertextLayer().getStartPage();
		for (IndexPage indexPage : indexPages) {
			boolean isLinked = false;
			for (Link link : startPage.getLinks()) {
				if (link.getTarget() == indexPage) {
					isLinked = true;
				}
			}
			if (! isLinked) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(indexPage);
				results.add(result);
			}
		}
		
		
		
		return results;		
	}
	
	private List<IndexPage> getAllIndexPages(EObject root) {
		List<IndexPage> indexPages = new ArrayList<IndexPage>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof IndexPage) {
				indexPages.add((IndexPage) eObject);
			}
		}
		return indexPages;
	}

}
