package simplewebmodel.smells;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.DynamicPage;
import simplewebmodel.Entity;

public class NoDynamicPage implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Entity> entities = getAllEntities(root);
		List<DynamicPage> dynamicPages = getAllDynamicPages(root);
		for (Entity entity : entities) {
			boolean isReferenced = false;
			for (DynamicPage dynamicPage : dynamicPages) {
				if (dynamicPage.getEntity() == entity) {
					isReferenced = true;
				}
			}
			if (! isReferenced) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(entity);
				results.add(result);
			}
		}
		return results;
	}
	
	public LinkedList<LinkedList<EObject>> findSmells(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Entity> entities = getAllEntities(root);
		List<DynamicPage> dynamicPages = getAllDynamicPages(root);
		for (Entity entity : entities) {
			boolean isReferenced = false;
			for (DynamicPage dynamicPage : dynamicPages) {
				if (dynamicPage.getEntity() == entity) isReferenced = true;
			}
			if (! isReferenced) addSmellOccurrence(entity); // SMELL FOUND !!!
		}
		return results;
	}
	
	private void addSmellOccurrence(Entity entity) {
		// TODO Auto-generated method stub
		
	}

	private List<Entity> getAllEntities(EObject root) {
		List<Entity> entities = new ArrayList<Entity>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Entity) {
				entities.add((Entity) eObject);
			}
		}
		return entities;
	}
	
	private List<DynamicPage> getAllDynamicPages(EObject root) {
		List<DynamicPage> dynamicPages = new ArrayList<DynamicPage>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof DynamicPage) {
				dynamicPages.add((DynamicPage) eObject);
			}
		}
		return dynamicPages;
	}

}
