/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.controls;

import java.io.IOException;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.internal.ide.util.EcoreHelper;
import org.eclipse.emf.ecp.view.internal.editor.controls.EditableEReferenceLabelControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.util.DMRCreationWizard;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class DMRSelectorControlSWTRenderer
extends EditableEReferenceLabelControlSWTRenderer {
    public DMRSelectorControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    protected void linkValue(Shell shell) {
        IObservableValue observableValue;
        DMRCreationWizard dmrWizard = new DMRCreationWizard();
        WizardDialog wd = new WizardDialog(shell, (IWizard)dmrWizard);
        int open = wd.open();
        if (1 == open) {
            return;
        }
        IFile selectedEcore = dmrWizard.getSelectedEcore();
        EStructuralFeature featureToSet = dmrWizard.getSelectedEStructuralFeature();
        if (selectedEcore != null) {
            try {
                String ecorePath = selectedEcore.getFullPath().toString();
                EcoreHelper.registerEcore((String)ecorePath);
                this.addEcorePathToTemplate(ecorePath);
                EPackage ePackage = (EPackage)featureToSet.eResource().getContents().get(0);
                EPackage registeredPackage = (EPackage)EPackage.Registry.INSTANCE.get((Object)ePackage.getNsURI());
                EClass eClass = (EClass)registeredPackage.getEClassifier(featureToSet.getEContainingClass().getName());
                featureToSet = eClass.getEStructuralFeature(featureToSet.getFeatureID());
            }
            catch (IOException ex) {
                Activator.log(ex);
            }
        }
        try {
            observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.showLinkValueFailedMessageDialog(shell, (Exception)((Object)ex));
            return;
        }
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        VFeaturePathDomainModelReference value = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
        value.setDomainModelEFeature(featureToSet);
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)value);
        editingDomain.getCommandStack().execute(command);
    }

    private void addEcorePathToTemplate(String ecorePath) {
        EObject domain = this.getViewModelContext().getDomainModel();
        while (!VTViewTemplate.class.isInstance(domain)) {
            domain = domain.eContainer();
        }
        if (!VTViewTemplate.class.isInstance(domain)) {
            return;
        }
        ((VTViewTemplate)VTViewTemplate.class.cast(domain)).getReferencedEcores().add((Object)ecorePath);
    }
}

