/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.emfstore.client.handler.ESNotificationFilter;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.common.model.ESObjectContainer;
import org.eclipse.emf.emfstore.common.model.util.ESNotificationInfo;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.EmptyRemovalsFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.IgnoreDatatypeFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.IgnoreNotificationsOutsideProject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.IgnoreNullFeatureNotificationsFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.IgnoreOutsideProjectReferencesFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.NotifiableIdEObjectCollectionFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.TouchFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.TransientFilter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.UnknownEventTypeFilter;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterStack
implements ESNotificationFilter {
    private static final String CLASS = "class";
    private static final String NOTIFICATION_FILTER_EXTENSION_ID = "org.eclipse.emf.emfstore.client.notificationFilter";
    private static final ESNotificationFilter[] DEFAULT_STACK = new ESNotificationFilter[]{new TouchFilter(), new TransientFilter(), new UnknownEventTypeFilter(), new EmptyRemovalsFilter(), new IgnoreDatatypeFilter(), new IgnoreOutsideProjectReferencesFilter(), new IgnoreNullFeatureNotificationsFilter(), new NotifiableIdEObjectCollectionFilter(), new IgnoreNotificationsOutsideProject()};
    public static final ESNotificationFilter DEFAULT = new FilterStack(DEFAULT_STACK);
    private final List<ESNotificationFilter> filterList = new LinkedList<ESNotificationFilter>();

    public FilterStack(ESNotificationFilter[] filters) {
        Collections.addAll(this.filterList, filters);
        this.collectExtensionPoints();
    }

    private void collectExtensionPoints() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint(NOTIFICATION_FILTER_EXTENSION_ID, true);
        for (ESExtensionElement element : extensionPoint.getExtensionElements()) {
            try {
                this.filterList.add((ESNotificationFilter)element.getClass(CLASS, ESNotificationFilter.class));
            }
            catch (ESExtensionPointException e) {
                WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    @Override
    public boolean check(ESNotificationInfo notificationInfo, ESObjectContainer<?> container) {
        for (ESNotificationFilter filter : this.filterList) {
            if (!filter.check(notificationInfo, container)) continue;
            return true;
        }
        return false;
    }
}

