/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.List;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Symbol;

public class context
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 1) {
            throw new ExprEvalException("Wrong number of arguments");
        }
    }

    @Override
    public NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        NodeValue v = args.get(0);
        if (!v.isString()) {
            throw new ExprEvalException("Not a string: function afn:context(" + v + ")");
        }
        Symbol symbol = Symbol.create(v.getString());
        return context.get(symbol, env);
    }

    public static NodeValue get(Symbol symbol, FunctionEnv env) {
        Object obj = env.getContext().get(symbol);
        if (obj == null) {
            return NodeValue.nvEmptyString;
        }
        if (obj instanceof String) {
            return NodeValue.makeString((String)obj);
        }
        if (!(obj instanceof Node)) {
            throw new ExprEvalException("Not a Node: " + Lib.className(obj));
        }
        Node n = (Node)obj;
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        throw new InternalErrorException("afn:context.exec(args) called");
    }
}

