/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.actions;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.eclipse.equinox.jmx.client.IJMXConnectorProvider;
import org.eclipse.equinox.jmx.internal.client.ui.actions.ActionMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ConnectionSelectionDialog
extends SelectionDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private JMXConnector connector;
    private Text hostText;
    private Text portText;
    private Combo transport;
    private Shell parent;
    private final Map transports;

    public ConnectionSelectionDialog(Shell parentShell, Map transports) {
        super(parentShell);
        this.transports = transports;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ActionMessages.connection_selection_dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent.getShell();
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        Composite fieldComposite = new Composite(composite, 0);
        fieldComposite.setLayout((Layout)new GridLayout(5, false));
        Label label = new Label(fieldComposite, 0x1000000);
        label.setText(ActionMessages.host);
        this.hostText = new Text(fieldComposite, 2048);
        this.hostText.setText("localhost");
        this.hostText.selectAll();
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(25);
        this.hostText.setLayoutData((Object)data);
        label = new Label(fieldComposite, 0x1000000);
        label.setText(ActionMessages.port);
        this.portText = new Text(fieldComposite, 2048);
        this.portText.setTextLimit(5);
        this.portText.setText("8118");
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(6);
        this.portText.setLayoutData((Object)data);
        this.transport = new Combo(fieldComposite, 12);
        Iterator iter = this.transports.keySet().iterator();
        while (iter.hasNext()) {
            this.transport.add((String)iter.next());
        }
        this.transport.select(0);
        return composite;
    }

    protected void okPressed() {
        int port;
        if (this.hostText.getText().equals("")) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)ActionMessages.error_message, (String)ActionMessages.invalid_host);
            return;
        }
        try {
            InetAddress.getByName(this.hostText.getText());
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)ActionMessages.error_message, (String)ActionMessages.invalid_host);
            return;
        }
        if (this.portText.getText().equals("")) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)ActionMessages.error_message, (String)ActionMessages.invalid_port);
            return;
        }
        try {
            port = Integer.parseInt(this.portText.getText());
            if (port < 1 || port > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)ActionMessages.error_message, (String)ActionMessages.invalid_port);
            return;
        }
        try {
            IJMXConnectorProvider ctorp = (IJMXConnectorProvider)this.transports.get(this.transport.getText());
            JMXServiceURL url = ctorp.getJMXServiceURL(this.hostText.getText(), port, this.transport.getText(), "jmxserver");
            this.connector = ctorp.newJMXConnector(url, null);
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)ActionMessages.error_message, (String)e.getMessage());
            super.cancelPressed();
            return;
        }
        super.okPressed();
    }

    public JMXConnector getJMXConnector() {
        return this.connector;
    }
}

