/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthState;

public class NTLMProxyDetector {
    private static final String PROXY_NTLM_VALUE = "NTLM";

    public static boolean detectNTLMProxy(HttpMethodBase method) {
        if (method == null) {
            return false;
        }
        AuthState authState = method.getProxyAuthState();
        if (authState == null) {
            return false;
        }
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        if (schemeName == null) {
            return false;
        }
        return schemeName.equalsIgnoreCase(PROXY_NTLM_VALUE);
    }
}

