/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soda.devicekit.editor.dkml.parse.DkmlTagManager;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.model.ITestRunSessionListener;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestRunSession;
import org.eclipse.soda.devicekit.ui.testmanager.util.ExceptionHandler;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerViewPart;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestSynchronizationDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class TestModel {
    private final ListenerList fTestRunSessionListeners = new ListenerList();
    private final LinkedList fTestRunSessions = new LinkedList();

    /*
     * Exception decompiling
     */
    public static void exportTestRunSession(TestRunSession testRunSession, File file) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 73->77)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void exportTestRunSession(TestRunSession testRunSession, IFile file) throws CoreException {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            TestModel.exportTestRunSession(testRunSession, out);
            file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), 1, null);
        }
        catch (IOException e) {
            TestModel.throwExportError(file.getFullPath().toString(), e);
        }
    }

    public static void exportTestRunSession(TestRunSession testRunSession, OutputStream out) throws IOException {
        DkmlTagManager manager = new DkmlTagManager(testRunSession.getDocument());
        out.write(manager.toString().getBytes());
    }

    static TestRunnerViewPart findTestRunnerViewPartInActivePage() {
        IWorkbenchPage page = TestManagerPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (TestRunnerViewPart)page.findView("org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerView");
    }

    public static String getElementDescription(Element element) {
        String descr = "";
        if (element != null) {
            Node node = element;
            while (node.getNodeType() != 9 && descr.length() == 0) {
                Node firstChild;
                NodeList nodes;
                Element e = node;
                if (e.hasAttribute("testName")) {
                    descr = e.getAttribute("testName");
                } else if (e.getNodeName().equals("actionRun") && (nodes = e.getChildNodes()).getLength() > 0 && (firstChild = nodes.item(0)).getNodeType() == 3) {
                    descr = firstChild.getNodeValue();
                }
                node = node.getParentNode();
            }
        }
        return descr;
    }

    public static String getTextContent(Node node) {
        StringBuffer buf = new StringBuffer();
        TestModel.getTextContent(node, buf);
        return buf.toString();
    }

    private static void getTextContent(Node node, StringBuffer buf) {
        if (node.getNodeType() == 3) {
            buf.append(node.getNodeValue());
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (TestModel.hasTextContent(child)) {
                TestModel.getTextContent(child, buf);
            }
            child = child.getNextSibling();
        }
    }

    public static boolean hasErrorInDecendants(Element element) {
        return element.getNodeName().equals("error") || element.getElementsByTagName("error").getLength() > 0;
    }

    public static boolean hasErrorOrFailureInDecendants(Element element) {
        return TestModel.isErrorOrFailure(element) || element.getElementsByTagName("error").getLength() > 0 || element.getElementsByTagName("failure").getLength() > 0;
    }

    public static boolean hasFailureInDecendants(Element element) {
        return element.getNodeName().equals("failure") || element.getElementsByTagName("failure").getLength() > 0;
    }

    private static boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7;
    }

    public static void importIntoTestRunSession(File swapFile, TestRunSession testRunSession) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new FileInputStream(swapFile)));
        testRunSession.setDocument(doc);
    }

    public static TestRunSession importTestRunSession(IFile file) throws CoreException {
        return TestModel.importTestRunSession(file.getContents(), file.getFullPath().toString());
    }

    public static TestRunSession importTestRunSession(File file) throws CoreException {
        String fileName = file.getAbsolutePath();
        try {
            return TestModel.importTestRunSession(new FileInputStream(file), fileName);
        }
        catch (FileNotFoundException e) {
            TestModel.throwImportError(fileName, e);
            return null;
        }
    }

    public static TestRunSession importTestRunSession(InputStream in, String fileName) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(in));
            Element docElement = doc.getDocumentElement();
            if (docElement.getNodeName().equals("validationTestReport")) {
                IJavaModel javaModel;
                String name = docElement.getAttribute("name");
                String project = docElement.getAttribute("project");
                IJavaProject javaProject = null;
                if (project.length() > 0 && !(javaProject = (javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot())).getJavaProject(project)).exists()) {
                    javaProject = null;
                }
                TestRunnerViewPart part = TestModel.findTestRunnerViewPartInActivePage();
                TestRunSession session = new TestRunSession(name, new TestSynchronizationDialog((IWorkbenchPart)part, name), javaProject);
                session.setDocument(doc);
                TestManagerPlugin.getModel().addTestRunSession(session);
                return session;
            }
        }
        catch (ParserConfigurationException e) {
            TestModel.throwImportError(fileName, e);
        }
        catch (SAXException e) {
            TestModel.throwImportError(fileName, e);
        }
        catch (IOException e) {
            TestModel.throwImportError(fileName, e);
        }
        return null;
    }

    public static boolean isErrorOrFailure(Node node) {
        String name = node.getNodeName();
        return node.getNodeType() == 1 && (name.equals("error") || name.equals("failure"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
        TestRunnerViewPart testRunnerViewPart;
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        block9: {
            block8: {
                TestRunnerViewPart testRunnerViewPart2;
                block7: {
                    activePart = null;
                    page = null;
                    try {
                        try {
                            if (testRunner != null && testRunner.isCreated()) {
                                testRunnerViewPart2 = testRunner;
                                Object var4_5 = null;
                                if (page == null) return testRunnerViewPart2;
                                if (activePart == null) return testRunnerViewPart2;
                                break block7;
                            }
                            page = TestManagerPlugin.getActivePage();
                            if (page == null) {
                                break block8;
                            }
                            activePart = page.getActivePart();
                            testRunnerViewPart = (TestRunnerViewPart)page.showView("org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerView");
                            break block9;
                        }
                        catch (PartInitException pie) {
                            if (testRunner == null) break block8;
                            ExceptionHandler.handle((CoreException)((Object)pie), testRunner.getSite().getShell(), TestManagerMessages.TestModel_OpenView_error_title, pie.getStatus().getMessage());
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        if (page == null) throw throwable;
                        if (activePart == null) throw throwable;
                        page.activate(activePart);
                        throw throwable;
                    }
                }
                page.activate(activePart);
                return testRunnerViewPart2;
            }
            Object var4_6 = null;
            if (page == null) return null;
            if (activePart == null) return null;
            page.activate(activePart);
            return null;
        }
        Object var4_7 = null;
        if (page == null) return testRunnerViewPart;
        if (activePart == null) return testRunnerViewPart;
        page.activate(activePart);
        return testRunnerViewPart;
    }

    private static void throwExportError(String fileName, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.soda.devicekit.ui.testmanager", TestManagerMessages.format(TestManagerMessages.TestModel_could_not_write, fileName), (Throwable)e));
    }

    private static void throwImportError(String fileName, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.soda.devicekit.ui.testmanager", TestManagerMessages.format(TestManagerMessages.TestModel_could_not_read, fileName), (Throwable)e));
    }

    public void addTestRunSession(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        Assert.isLegal((!this.fTestRunSessions.contains(testRunSession) ? 1 : 0) != 0);
        this.fTestRunSessions.addFirst(testRunSession);
        this.notifyTestRunSessionAdded(testRunSession);
    }

    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    public void createTestRunSession(IStorage testScript, IJavaProject javaProject) {
        TestRunnerViewPart part = TestModel.showTestRunnerViewPartInActivePage(TestModel.findTestRunnerViewPartInActivePage());
        int maxCount = TestManagerPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.soda.devicekit.ui.testmanager.max_test_runs");
        int toDelete = this.fTestRunSessions.size() - maxCount;
        while (toDelete > 0) {
            --toDelete;
            TestRunSession session = (TestRunSession)this.fTestRunSessions.removeLast();
            this.notifyTestRunSessionRemoved(session);
        }
        TestRunSession testRunSession = new TestRunSession(testScript, new TestSynchronizationDialog((IWorkbenchPart)part, testScript.getName()), javaProject);
        this.addTestRunSession(testRunSession);
        testRunSession.runTest();
    }

    public List getTestRunSessions() {
        return new ArrayList(this.fTestRunSessions);
    }

    private void notifyTestRunSessionAdded(TestRunSession testRunSession) {
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionAdded(testRunSession);
            ++i;
        }
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        testRunSession.stopTestRun();
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionRemoved(testRunSession);
            ++i;
        }
    }

    public TestRunSession openTestRunSession(File file) throws CoreException {
        TestModel.showTestRunnerViewPartInActivePage(TestModel.findTestRunnerViewPartInActivePage());
        int maxCount = TestManagerPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.soda.devicekit.ui.testmanager.max_test_runs");
        int toDelete = this.fTestRunSessions.size() - maxCount;
        while (toDelete > 0) {
            --toDelete;
            TestRunSession session = (TestRunSession)this.fTestRunSessions.removeLast();
            this.notifyTestRunSessionRemoved(session);
        }
        return TestModel.importTestRunSession(file);
    }

    public void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed = this.fTestRunSessions.remove(testRunSession);
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
    }

    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    public void start() {
    }

    public void stop() {
    }
}

