/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.util;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay = TestManagerPlugin.getStandardDisplay();

    public ImageRegistry() {
        Assert.isNotNull((Object)this.fDisplay);
        this.fDisplay.disposeExec(new Runnable(){

            public void run() {
                ImageRegistry.this.dispose();
            }
        });
    }

    public void dispose() {
        Iterator iter = this.fRegistry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.fRegistry.clear();
    }

    public Image get(ImageDescriptor descriptor) {
        ImageDescriptor descr = descriptor == null ? ImageDescriptor.getMissingImageDescriptor() : descriptor;
        Image result = (Image)this.fRegistry.get(descr);
        if (result != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == TestManagerPlugin.getStandardDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        result = descr.createImage();
        if (result != null) {
            this.fRegistry.put(descr, result);
        }
        return result;
    }
}

