/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;

public class TestManagerImages {
    private static final URL BASE_URL = TestManagerPlugin.getDefault().getBundle().getEntry("/");
    public static final String ICONS_PATH = "icons/full/";
    public static final String DLCL_PATH = "dlcl16/";
    public static final String ELCL_PATH = "elcl16/";
    public static final String OBJ_PATH = "obj16/";
    public static final String OVR_PATH = "ovr16/";
    public static final String EVIEW_PATH = "eview16/";
    public static final String PRGSS_PATH = "prgss/";
    public static final ImageDescriptor fgSuccessOverlayImageDescriptor = TestManagerImages.createImageDescriptor("ovr16/", "success_ovr.gif");
    public static final ImageDescriptor fgErrorOverlayImageDescriptor = TestManagerImages.createImageDescriptor("ovr16/", "error_ovr.gif");
    public static final ImageDescriptor fgFailedOverlayImageDescriptor = TestManagerImages.createImageDescriptor("ovr16/", "failed_ovr.gif");
    public static final ImageDescriptor fgValidationTestViewImageDescriptor = TestManagerImages.createImageDescriptor("eview16/", "vtest.gif");
    private static TestManagerImages fTestManagerImages = new TestManagerImages();

    private TestManagerImages() {
    }

    public static ImageDescriptor createImageDescriptor(String pathPrefix, String name) {
        return TestManagerImages.createImageDescriptor(pathPrefix, name, false);
    }

    private static ImageDescriptor createImageDescriptor(String pathPrefix, String imageName, boolean useMissingImageDescriptor) {
        URL url = TestManagerImages.makeImageURL(ICONS_PATH + pathPrefix, imageName);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public static TestManagerImages getInstance() {
        return fTestManagerImages;
    }

    private static URL makeImageURL(String prefix, String name) {
        String path = String.valueOf(prefix) + name;
        URL url = null;
        try {
            url = new URL(BASE_URL, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return url;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = TestManagerImages.createImageDescriptor("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = TestManagerImages.createImageDescriptor("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        TestManagerImages.setImageDescriptors(action, "lcl16/", iconName);
    }
}

