/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.view.FailureTrace;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class CopyAction
extends SelectionListenerAction {
    private FailureTrace fView;
    private final Clipboard fClipboard;
    private String fTestDescription;

    public CopyAction(FailureTrace view, Clipboard clipboard) {
        super(TestManagerMessages.CopyTrace_action_label);
        Assert.isNotNull((Object)clipboard);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.soda.devicekit.ui.testmanager.copy_trace_action_context");
        this.fView = view;
        this.fClipboard = clipboard;
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return in;
        }
        return stringWriter.toString();
    }

    public void handleTestSelected(String testDescription) {
        this.fTestDescription = testDescription;
    }

    public void run() {
        block6: {
            String trace = this.fView.getTrace();
            String source = null;
            if (trace != null) {
                source = this.convertLineTerminators(trace);
            }
            if (source == null || source.length() == 0) {
                return;
            }
            if (this.fTestDescription != null) {
                String lineDelim = System.getProperty("line.separator", "\n");
                source = String.valueOf(this.fTestDescription) + lineDelim + source;
            }
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{source}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getComposite().getShell(), (String)TestManagerMessages.CopyTraceAction_problem, (String)TestManagerMessages.CopyTraceAction_clipboard_busy)) break block6;
                this.run();
            }
        }
    }
}

