/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.util.TestManagerImages;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class TestSynchronizationDialog
implements TestSynchronizationService {
    IWorkbenchPart part;
    Set dialogs;
    String scriptName;

    public TestSynchronizationDialog(IWorkbenchPart part, String scriptName) {
        this.part = part;
        this.scriptName = scriptName;
        this.dialogs = new HashSet();
    }

    public boolean requestConfirmation(final String prompt, final String testName) throws InterruptedException, IOException {
        final boolean[] confirmation = new boolean[1];
        this.part.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = TestSynchronizationDialog.this.part.getSite().getWorkbenchWindow().getShell();
                ModelessMessageDialog dialog = new ModelessMessageDialog(shell, TestSynchronizationDialog.this.scriptName, testName, prompt);
                TestSynchronizationDialog.this.dialogs.add(dialog);
                confirmation[0] = dialog.open() == 0;
                TestSynchronizationDialog.this.dialogs.remove((Object)dialog);
            }
        });
        return confirmation[0];
    }

    public void interrupt() {
        Iterator iterator = this.dialogs.iterator();
        while (iterator.hasNext()) {
            MessageDialog dialog = (MessageDialog)iterator.next();
            dialog.close();
        }
    }

    private static class ModelessMessageDialog
    extends MessageDialog {
        private static final int MINIMUM_MESSAGE_AREA_WIDTH = 450;
        private String scriptName;
        private String testName;

        public ModelessMessageDialog(Shell parentShell, String scriptName, String testName, String prompt) {
            super(parentShell, TestManagerMessages.TestSynchronizationDialog_ConfirmationDialog_title, TestManagerPlugin.getImageDescriptorRegistry().get(TestManagerImages.fgValidationTestViewImageDescriptor), prompt, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
            this.scriptName = scriptName;
            this.testName = testName;
        }

        protected Control createCustomArea(Composite parent) {
            Group group = new Group(parent, 4);
            group.setLayout((Layout)new GridLayout(2, false));
            Label scriptNameLabel = new Label((Composite)group, 0);
            scriptNameLabel.setText(TestManagerMessages.TestSynchronizationDialog_ScriptNameLabel);
            Label scriptName = new Label((Composite)group, 64);
            scriptName.setText(this.scriptName);
            scriptNameLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            scriptName.setLayoutData((Object)new GridData(4, 1, true, false));
            Label testNameLabel = new Label((Composite)group, 0);
            testNameLabel.setText(TestManagerMessages.TestSynchronizationDialog_TestNameLabel);
            Label testName = new Label((Composite)group, 64);
            testName.setText(this.testName);
            testNameLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            testName.setLayoutData((Object)new GridData(4, 1, true, false));
            GridData gridDataGroup = new GridData(4, 1, true, false);
            gridDataGroup.widthHint = this.getMinimumMessageWidth();
            group.setLayoutData((Object)gridDataGroup);
            return group;
        }

        protected int getMinimumMessageWidth() {
            return this.convertHorizontalDLUsToPixels(450);
        }
    }
}

