/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Task_Array
extends AbstractTask
implements ITaskListener {
    private String taskName;
    private ITask[] tasks;
    private int currentTask = -1;

    public Task_Array(String taskName, ITask[] tasks) {
        this.taskName = taskName;
        this.tasks = tasks;
    }

    public boolean duplicateTask(ITask task) {
        return task.getTaskName().equals(this.taskName);
    }

    private synchronized int getCurrentTask() {
        return this.currentTask;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        if (this.getCurrentTask() < 0) {
            return;
        }
        this.tasks[this.getCurrentTask()].handleResponse(source, timestamp, data);
    }

    public boolean isResponseExpected(SignalService source, Object timestamp, Object data) {
        if (this.isLogging(4)) {
            this.log(4, String.valueOf(this.taskName) + ": isResponseExpected, currentTask: " + this.getCurrentTask() + ", source: " + source);
        }
        if (this.getCurrentTask() < 0) {
            return false;
        }
        if (this.tasks[this.getCurrentTask()].getTaskManager() != null && this.tasks[this.getCurrentTask()].getTaskManager() != this.getTaskManager()) {
            return false;
        }
        return this.tasks[this.getCurrentTask()].isResponseExpected(source, timestamp, data);
    }

    public boolean launchTask() {
        if (this.tasks.length == 0 || this.tasks[0] == null) {
            this.setCurrentTask(-1);
            return false;
        }
        this.tasks[0].addTaskListener(this);
        this.tasks[0].start();
        if (this.isLogging(4)) {
            this.log(4, "Started task: " + this.tasks[0].getTaskName() + " in " + this.taskName);
        }
        this.setCurrentTask(0);
        if (this.isLogging(4)) {
            this.log(4, String.valueOf(this.taskName) + ": launchTask, currentTask: " + this.getCurrentTask());
        }
        return true;
    }

    private synchronized void setCurrentTask(int currentTask) {
        this.currentTask = currentTask;
    }

    public void setTasks(ITask[] tasks) {
        this.tasks = tasks;
    }

    public synchronized void taskNotice(String taskName, int status, Object result) {
        if (status == 0) {
            if (this.isLogging(4)) {
                this.log(4, "Task Error: " + taskName + " in " + this.taskName);
            }
            this.notifyListener(this.taskName, status, result);
            return;
        }
        if (status == 2) {
            if (this.isLogging(4)) {
                this.log(4, "Task Timeout: " + taskName + " in " + this.taskName);
            }
            this.notifyListener(this.taskName, status, result);
            return;
        }
        if (status == 1) {
            if (this.isLogging(4)) {
                this.log(4, "Finished Task: " + taskName + " in " + this.taskName);
            }
            this.tasks[this.getCurrentTask()].removeTaskListener(this);
            if (this.getCurrentTask() + 1 < this.tasks.length && this.tasks[this.getCurrentTask() + 1] != null) {
                this.tasks[this.getCurrentTask() + 1].addTaskListener(this);
                this.tasks[this.getCurrentTask() + 1].start();
                this.setCurrentTask(this.getCurrentTask() + 1);
                if (this.isLogging(4)) {
                    this.log(4, "Started task: " + this.tasks[this.getCurrentTask()].getTaskName() + " in " + this.taskName);
                }
            } else {
                this.setCurrentTask(-1);
                this.notifyListener(this.taskName, 1, result);
            }
        }
    }
}

