/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager.IIdManager;

public abstract class AbstractLLRPIdManager
implements IIdManager {
    protected static final int DEFAULT_START = 1;
    protected static final int UNLIMITED = 0;
    protected static final String OWNER_KEY = "Owner";
    protected static final String STATUS_KEY = "Status";
    private SortedMap idRepository = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            int id1 = ((IdKey)o1).getId();
            int id2 = ((IdKey)o2).getId();
            return id1 - id2;
        }
    }){
        private static final long serialVersionUID = 1L;

        public boolean containsKey(Object key) {
            if (key instanceof IdKey) {
                return super.containsKey(key);
            }
            return super.containsKey(new IdKey(key));
        }

        public Object get(Object key) {
            if (key instanceof IdKey) {
                return super.get(key);
            }
            return super.get(new IdKey(key));
        }

        public Object put(Object key, Object value) {
            if (key instanceof IdKey) {
                return super.put(key, value);
            }
            return super.put(new IdKey(key), value);
        }

        public Object remove(Object key) {
            if (key instanceof IdKey) {
                return super.remove(key);
            }
            return super.remove(new IdKey(key));
        }
    };
    private int startId;
    private int maxIdNum;
    private Map idContentMapRepository;

    protected AbstractLLRPIdManager() {
        this(1, 0);
    }

    protected AbstractLLRPIdManager(int startId, int maxIdNum) {
        this.startId = startId;
        this.maxIdNum = maxIdNum;
    }

    private void clearStoppedId(Object idObj) {
        Integer status;
        Map idContent = (Map)this.idRepository.get(idObj);
        if (idContent != null && (status = (Integer)idContent.get(STATUS_KEY)) != null && status == 12) {
            this.idRepository.remove(idObj);
        }
    }

    protected Map createIDContentMap(Object idObj, Object owner, int status) {
        Map idContentMap = (Map)this.getIdContentMapRepository().get(idObj);
        if (idContentMap == null) {
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            result.put(OWNER_KEY, owner);
            result.put(STATUS_KEY, EscObject.createInteger((int)status));
            this.getIdContentMapRepository().put(idObj, result);
            return result;
        }
        idContentMap.put(OWNER_KEY, owner);
        idContentMap.put(STATUS_KEY, EscObject.createInteger((int)status));
        return idContentMap;
    }

    protected abstract Object createIdObj(int var1);

    protected abstract int extractId(Object var1);

    private int getCurrentStartedId() {
        int result = 0;
        Iterator ids = this.idRepository.entrySet().iterator();
        while (ids.hasNext()) {
            Integer status;
            Map.Entry entry = ids.next();
            Map idContent = (Map)entry.getValue();
            if (idContent == null || (status = (Integer)idContent.get(STATUS_KEY)) != 11) continue;
            ++result;
        }
        return result;
    }

    private Map getIdContentMapRepository() {
        if (this.idContentMapRepository == null) {
            this.idContentMapRepository = new Hashtable();
        }
        return this.idContentMapRepository;
    }

    protected synchronized int getIdStatus(Object idObj) {
        Integer status;
        Map idContent = (Map)this.idRepository.get(idObj);
        if (idContent != null && (status = (Integer)idContent.get(STATUS_KEY)) != null) {
            return status;
        }
        return -13;
    }

    public synchronized int getIdStatus(Object idObj, Object owner) {
        Map idContent = (Map)this.idRepository.get(idObj);
        if (idContent != null) {
            Object tOwner = idContent.get(OWNER_KEY);
            Integer status = (Integer)idContent.get(STATUS_KEY);
            if (tOwner.equals(owner) && status != null) {
                return status;
            }
        }
        return -13;
    }

    public synchronized int getIdStatus(int id, Object owner) {
        return this.getIdStatus(this.createIdObj(id), owner);
    }

    public synchronized List getIds(Object owner) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator ids = this.idRepository.entrySet().iterator();
        while (ids.hasNext()) {
            Object tOwner;
            Map.Entry entry = ids.next();
            Object idObj = ((IdKey)entry.getKey()).getIdObj();
            Map idContent = (Map)entry.getValue();
            if (idContent == null || !(tOwner = idContent.get(OWNER_KEY)).equals(owner)) continue;
            result.add(idObj);
        }
        return result;
    }

    public int getMaxIdNum() {
        return this.maxIdNum;
    }

    public synchronized Object getOwner(Object idObj) {
        Map idContent = (Map)this.idRepository.get(idObj);
        if (idContent != null) {
            return idContent.get(OWNER_KEY);
        }
        return null;
    }

    public Object getOwner(int id) {
        return this.getOwner(this.createIdObj(id));
    }

    public int getStartId() {
        return this.startId;
    }

    public synchronized boolean isAllIdsStarted(Object owner) {
        Iterator ids = this.idRepository.entrySet().iterator();
        while (ids.hasNext()) {
            Map.Entry entry = ids.next();
            Map idContent = (Map)entry.getValue();
            if (idContent == null) continue;
            Object tOwner = idContent.get(OWNER_KEY);
            Integer status = (Integer)idContent.get(STATUS_KEY);
            if (!tOwner.equals(owner) || status == null || status == 11) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isAllIdsStopped(Object owner) {
        Iterator ids = this.idRepository.entrySet().iterator();
        while (ids.hasNext()) {
            Map.Entry entry = ids.next();
            Map idContent = (Map)entry.getValue();
            if (idContent == null) continue;
            Object tOwner = idContent.get(OWNER_KEY);
            Integer status = (Integer)idContent.get(STATUS_KEY);
            if (!tOwner.equals(owner) || status == null || status == 12) continue;
            return false;
        }
        return true;
    }

    public synchronized int registerId(Object idObj, Object owner) {
        int id;
        if (this.getMaxIdNum() != 0 && this.getCurrentStartedId() >= this.getMaxIdNum()) {
            return -2;
        }
        if (this.idRepository.containsKey(idObj)) {
            if (this.getOwner(idObj) == owner) {
                return 0;
            }
            if (this.getIdStatus(idObj) != 12 && this.getIdStatus(idObj) != 13) {
                return -1;
            }
            this.removeId(idObj);
        }
        if ((id = this.extractId(idObj)) < this.getStartId()) {
            return -3;
        }
        this.idRepository.put(idObj, this.createIDContentMap(idObj, owner, 10));
        return 0;
    }

    public synchronized int registerId(int id, Object owner) {
        return this.registerId(this.createIdObj(id), owner);
    }

    public synchronized int registerNextId(Object owner) {
        if (this.getMaxIdNum() != 0 && this.getCurrentStartedId() >= this.getMaxIdNum()) {
            return -2;
        }
        int id = this.getStartId();
        while (id <= this.getMaxIdNum() || this.getMaxIdNum() == 0) {
            Object idObj = this.createIdObj(id);
            this.clearStoppedId(idObj);
            if (!this.idRepository.containsKey(idObj)) {
                this.idRepository.put(idObj, this.createIDContentMap(idObj, owner, 10));
                return id;
            }
            ++id;
        }
        return -2;
    }

    public synchronized void removeId(Object idObj) {
        this.idRepository.remove(idObj);
    }

    public synchronized void removeIdsByOwner(Object owner) {
        ArrayList removedIds = null;
        Iterator ids = this.idRepository.entrySet().iterator();
        while (ids.hasNext()) {
            Object tOwner;
            Map.Entry entry = ids.next();
            Object idObj = entry.getKey();
            Map idContent = (Map)entry.getValue();
            if (idContent == null || !(tOwner = idContent.get(OWNER_KEY)).equals(owner)) continue;
            if (removedIds == null) {
                removedIds = new ArrayList();
            }
            removedIds.add(idObj);
        }
        if (removedIds != null) {
            int i = 0;
            while (i < removedIds.size()) {
                this.idRepository.remove(removedIds.get(i));
                ++i;
            }
        }
    }

    public synchronized void reset() {
        this.idRepository.clear();
    }

    public synchronized int setIdStatus(int id, Object owner, int status) {
        return this.setIdStatus(this.createIdObj(id), owner, status);
    }

    public synchronized int setIdStatus(Object idObj, Object owner, int status) {
        Object tOwner;
        Map idContent = (Map)this.idRepository.get(idObj);
        if (idContent != null && (tOwner = idContent.get(OWNER_KEY)).equals(owner)) {
            idContent.put(STATUS_KEY, EscObject.createInteger((int)status));
        }
        return -13;
    }

    public void setMaxIdNum(int maxIdNum) {
        this.maxIdNum = maxIdNum;
    }

    public void setStartId(int startId) {
        this.startId = startId;
    }

    class IdKey {
        private Object idObj;

        public IdKey(Object idObj) {
            this.idObj = idObj;
        }

        public boolean equals(Object obj) {
            return obj instanceof IdKey && this.getId() == ((IdKey)obj).getId();
        }

        public int getId() {
            return AbstractLLRPIdManager.this.extractId(this.idObj);
        }

        public Object getIdObj() {
            return this.idObj;
        }
    }
}

