/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.AbstractLLRPTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.ILLRPCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Task_GET_READER_CAPABILITIES
extends AbstractLLRPTask
implements ILLRPCapabilities {
    public static final String TASKNAME = "Task_GET_READER_CAPABILITIES";
    private Map capabilities;
    private boolean canDoRFSurvey;
    private boolean canDoTagInventoryStateAwaresingulation;
    private boolean canReportBufferFillWarning;
    private int maxNumROSpecs;
    private int maxNumSpecsPerROSpecs;
    private int maxNumInventoryParameterSpecsperAISpec;
    private int maxPriorityLevelSupported;
    private int maxNumAccessSpecs;
    private int maxNumOpSpecsPerAccessSpec;
    private boolean supportsClientRequestOpSpec;
    private int clientRequestOpSpecTimeout;
    private boolean supportsEventAndREportHolding;
    private boolean canSupportBlockErase;
    private boolean canSupportBlockWrite;
    private int maxNumSelectFiltersPerQuery;
    private int maxNumberOfAntennaSupported;
    private boolean canSetAntennaProperties;
    private boolean hasUTCClockCapability;
    private int deviceManufacturerName;
    private int modelName;
    private String readerFirmwareVersion;
    private List receiveSensitivityTable;
    private List perAntennaReceiveSensitivityRange;
    private int numGPIs;
    private int numGPOs;
    private List perAntennaAirProtocol;
    private int countryCode;
    private int communicationsStandard;
    private Map uHFBandCapabilities;

    public Task_GET_READER_CAPABILITIES(CommandService command, SignalService signal) {
        super(command, null, signal);
    }

    public Task_GET_READER_CAPABILITIES(CommandService command, Map parameters, SignalService signal) {
        super(command, parameters, signal);
    }

    public Task_GET_READER_CAPABILITIES(CommandService command, Map parameters, SignalService signal, long timeoutValue) {
        super(command, parameters, signal, timeoutValue);
    }

    public boolean duplicateTask(ITask task) {
        return this.isSameTaskType(task);
    }

    public Map getCapabilities() {
        return this.capabilities;
    }

    public int getClientRequestOpSpecTimeout() {
        return this.clientRequestOpSpecTimeout;
    }

    public int getCommunicationsStandard() {
        return this.communicationsStandard;
    }

    public int getCountryCode() {
        return this.countryCode;
    }

    public int getDeviceManufacturerName() {
        return this.deviceManufacturerName;
    }

    public int getMaxNumAccessSpecs() {
        return this.maxNumAccessSpecs;
    }

    public int getMaxNumInventoryParameterSpecsperAISpec() {
        return this.maxNumInventoryParameterSpecsperAISpec;
    }

    public int getMaxNumOpSpecsPerAccessSpec() {
        return this.maxNumOpSpecsPerAccessSpec;
    }

    public int getMaxNumROSpecs() {
        return this.maxNumROSpecs;
    }

    public int getMaxNumSelectFiltersPerQuery() {
        return this.maxNumSelectFiltersPerQuery;
    }

    public int getMaxNumSpecsPerROSpecs() {
        return this.maxNumSpecsPerROSpecs;
    }

    public int getMaxNumberOfAntennaSupported() {
        return this.maxNumberOfAntennaSupported;
    }

    public int getMaxPriorityLevelSupported() {
        return this.maxPriorityLevelSupported;
    }

    public int getModelName() {
        return this.modelName;
    }

    public int getNumGPIs() {
        return this.numGPIs;
    }

    public int getNumGPOs() {
        return this.numGPOs;
    }

    public List getPerAntennaAirProtocol() {
        return this.perAntennaAirProtocol;
    }

    public List getPerAntennaReceiveSensitivityRange() {
        return this.perAntennaReceiveSensitivityRange;
    }

    public String getReaderFirmwareVersion() {
        return this.readerFirmwareVersion;
    }

    public List getReceiveSensitivityTable() {
        return this.receiveSensitivityTable;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public Map getUHFBandCapabilities() {
        return this.uHFBandCapabilities;
    }

    public void handleResponse(SignalService source, Object timestamp, Object data) {
        Map responseMap;
        if (source == this.getSignal() && data instanceof Map && this.successInLLRPStatus(responseMap = (Map)data)) {
            if (this.isLogging(4)) {
                this.log(4, "Task " + this.getTaskName() + " received success response.");
            }
            this.populateReaderCapabilities(responseMap);
            this.notifyListener(this.getTaskName(), 1, responseMap);
        }
    }

    public boolean isCanDoRFSurvey() {
        return this.canDoRFSurvey;
    }

    public boolean isCanDoTagInventoryStateAwaresingulation() {
        return this.canDoTagInventoryStateAwaresingulation;
    }

    public boolean isCanReportBufferFillWarning() {
        return this.canReportBufferFillWarning;
    }

    public boolean isCanSetAntennaProperties() {
        return this.canSetAntennaProperties;
    }

    public boolean isCanSupportBlockErase() {
        return this.canSupportBlockErase;
    }

    public boolean isCanSupportBlockWrite() {
        return this.canSupportBlockWrite;
    }

    public boolean isHasUTCClockCapability() {
        return this.hasUTCClockCapability;
    }

    protected boolean isSameTaskType(ITask task) {
        return task instanceof Task_GET_READER_CAPABILITIES;
    }

    public boolean isSupportsClientRequestOpSpec() {
        return this.supportsClientRequestOpSpec;
    }

    public boolean isSupportsEventAndREportHolding() {
        return this.supportsEventAndREportHolding;
    }

    private void populateC1G2LLRPCapabilites(Map c1G2LLRPCapabilities) {
        Number objMaxNumSelectFiltersPerQuery;
        Boolean objCanSupportBlockWrite;
        Boolean objCanSupportBlockErase = (Boolean)c1G2LLRPCapabilities.get("CanSupportBlockErase");
        if (objCanSupportBlockErase != null) {
            this.canSupportBlockErase = objCanSupportBlockErase;
        }
        if ((objCanSupportBlockWrite = (Boolean)c1G2LLRPCapabilities.get("CanSupportBlockWrite")) != null) {
            this.canSupportBlockWrite = objCanSupportBlockWrite;
        }
        if ((objMaxNumSelectFiltersPerQuery = (Number)c1G2LLRPCapabilities.get("MaxNumSelectFiltersPerQuery")) != null) {
            this.maxNumSelectFiltersPerQuery = objMaxNumSelectFiltersPerQuery.intValue();
        }
    }

    private void populateGeneralDeviceCapabilities(Map generalDeviceCapabilities) {
        Number objModelName;
        Number objDeviceManufacturerName;
        Boolean objHasUTCClockCapability;
        Boolean objCanSetAntennaProperties;
        Number objMaxNumberOfAntennaSupported = (Number)generalDeviceCapabilities.get("MaxNumberOfAntennaSupported");
        if (objMaxNumberOfAntennaSupported != null) {
            this.maxNumberOfAntennaSupported = objMaxNumberOfAntennaSupported.intValue();
        }
        if ((objCanSetAntennaProperties = (Boolean)generalDeviceCapabilities.get("CanSetAntennaProperties")) != null) {
            this.canSetAntennaProperties = objCanSetAntennaProperties;
        }
        if ((objHasUTCClockCapability = (Boolean)generalDeviceCapabilities.get("HasUTCClockCapability")) != null) {
            this.hasUTCClockCapability = objHasUTCClockCapability;
        }
        if ((objDeviceManufacturerName = (Number)generalDeviceCapabilities.get("DeviceManufacturerName")) != null) {
            this.deviceManufacturerName = objDeviceManufacturerName.intValue();
        }
        if ((objModelName = (Number)generalDeviceCapabilities.get("ModelName")) != null) {
            this.modelName = objModelName.intValue();
        }
        this.readerFirmwareVersion = (String)generalDeviceCapabilities.get("ReaderFirmwareVersion");
        this.receiveSensitivityTable = (List)generalDeviceCapabilities.get("ReceiveSensitivityTableEntryParameter");
        this.perAntennaReceiveSensitivityRange = (List)generalDeviceCapabilities.get("PerAntennaReceiveSensitivityRangeParameter");
        this.perAntennaAirProtocol = (List)generalDeviceCapabilities.get("PerAntennaAirProtocolParameter");
        Map gPIOCapabilities = (Map)generalDeviceCapabilities.get("GPIOCapabilitiesParameter");
        if (gPIOCapabilities != null) {
            Number objNumGPOs;
            Number objNumGPIs = (Number)gPIOCapabilities.get("NumGPIs");
            if (objNumGPIs != null) {
                this.numGPIs = objNumGPIs.intValue();
            }
            if ((objNumGPOs = (Number)gPIOCapabilities.get("NumGPOs")) != null) {
                this.numGPOs = objNumGPOs.intValue();
            }
        }
    }

    private void populateLLRPCapabilities(Map lLRPCapabilities) {
        Number objMaxNumOpSpecsPerAccessSpec;
        Number objMaxNumAccessSpecs;
        Number objMaxNumInventoryParameterSpecsPerAISpec;
        Number objMaxNumSpecsPerROSpec;
        Number objMaxNumROSpecs;
        Number objClientRequestOpSpecTimeout;
        Number objMaxPriorityLevelSupported;
        Boolean objSupportsEventAndReportHolding;
        Boolean objCanDoTagInventoryStateAwareSingulation;
        Boolean objSupportsClientRequestOpSpec;
        Boolean objCanReportBufferFillWarning;
        Boolean objCanDoRFSurvey = (Boolean)lLRPCapabilities.get("CanDoRFSurvey");
        if (objCanDoRFSurvey != null) {
            this.canDoRFSurvey = objCanDoRFSurvey;
        }
        if ((objCanReportBufferFillWarning = (Boolean)lLRPCapabilities.get("CanReportBufferFillWarning")) != null) {
            this.canReportBufferFillWarning = objCanReportBufferFillWarning;
        }
        if ((objSupportsClientRequestOpSpec = (Boolean)lLRPCapabilities.get("SupportsClientRequestOpSpec")) != null) {
            this.supportsClientRequestOpSpec = objSupportsClientRequestOpSpec;
        }
        if ((objCanDoTagInventoryStateAwareSingulation = (Boolean)lLRPCapabilities.get("CanDoTagInventoryStateAwareSingulation")) != null) {
            this.canDoTagInventoryStateAwaresingulation = objCanDoTagInventoryStateAwareSingulation;
        }
        if ((objSupportsEventAndReportHolding = (Boolean)lLRPCapabilities.get("SupportsEventAndReportHolding")) != null) {
            this.supportsEventAndREportHolding = objSupportsEventAndReportHolding;
        }
        if ((objMaxPriorityLevelSupported = (Number)lLRPCapabilities.get("MaxNumPriorityLevelsSupported")) != null) {
            this.maxPriorityLevelSupported = objMaxPriorityLevelSupported.intValue();
        }
        if ((objClientRequestOpSpecTimeout = (Number)lLRPCapabilities.get("ClientRequestOpSpecTimeout")) != null) {
            this.clientRequestOpSpecTimeout = objClientRequestOpSpecTimeout.intValue();
        }
        if ((objMaxNumROSpecs = (Number)lLRPCapabilities.get("MaxNumROSpecs")) != null) {
            this.maxNumROSpecs = objMaxNumROSpecs.intValue();
        }
        if ((objMaxNumSpecsPerROSpec = (Number)lLRPCapabilities.get("MaxNumSpecsPerROSpec")) != null) {
            this.maxNumSpecsPerROSpecs = objMaxNumSpecsPerROSpec.intValue();
        }
        if ((objMaxNumInventoryParameterSpecsPerAISpec = (Number)lLRPCapabilities.get("MaxNumInventoryParameterSpecsPerAISpec")) != null) {
            this.maxNumInventoryParameterSpecsperAISpec = objMaxNumInventoryParameterSpecsPerAISpec.intValue();
        }
        if ((objMaxNumAccessSpecs = (Number)lLRPCapabilities.get("MaxNumAccessSpecs")) != null) {
            this.maxNumAccessSpecs = objMaxNumAccessSpecs.intValue();
        }
        if ((objMaxNumOpSpecsPerAccessSpec = (Number)lLRPCapabilities.get("MaxNumOpSpecsPerAccessSpec")) != null) {
            this.maxNumOpSpecsPerAccessSpec = objMaxNumOpSpecsPerAccessSpec.intValue();
        }
    }

    private void populateReaderCapabilities(Map responseMap) {
        Map regulatoryCapabilities;
        Map airProtocolLLRPCapabilitiesChoice;
        Map lLRPCapabilities;
        this.capabilities = responseMap;
        Map generalDeviceCapabilities = (Map)responseMap.get("GeneralDeviceCapabilitiesParameter");
        if (generalDeviceCapabilities != null) {
            this.populateGeneralDeviceCapabilities(generalDeviceCapabilities);
        }
        if ((lLRPCapabilities = (Map)responseMap.get("LLRPCapabilitiesParameter")) != null) {
            this.populateLLRPCapabilities(lLRPCapabilities);
        }
        if ((airProtocolLLRPCapabilitiesChoice = (Map)responseMap.get("AirProtocolLLRPCapabilitiesChoice")) != null) {
            Map c1G2LLRPCapabilities = airProtocolLLRPCapabilitiesChoice;
            this.populateC1G2LLRPCapabilites(c1G2LLRPCapabilities);
        }
        if ((regulatoryCapabilities = (Map)responseMap.get("RegulatoryCapabilitiesParameter")) != null) {
            this.populateRegulatoryCapabilities(regulatoryCapabilities);
        }
    }

    private void populateRegulatoryCapabilities(Map regulatoryCapabilities) {
        Number objCommunicationsStandard;
        Number objCountryCode = (Number)regulatoryCapabilities.get("CountryCode");
        if (objCountryCode != null) {
            this.countryCode = objCountryCode.intValue();
        }
        if ((objCommunicationsStandard = (Number)regulatoryCapabilities.get("CommunicationsStandard")) != null) {
            this.communicationsStandard = objCommunicationsStandard.intValue();
        }
        this.uHFBandCapabilities = (Map)regulatoryCapabilities.get("UHFBandCapabilitiesParameter");
    }

    public String printAllCapabilities() {
        StringBuffer result = new StringBuffer();
        result.append(this.printGeneralDeviceCapabilities());
        result.append(this.printLLRPCapabilities());
        result.append(this.printC1G2LLRPCapabilities());
        result.append(this.printRegulatoryCapabilities());
        return result.toString();
    }

    public String printC1G2LLRPCapabilities() {
        StringBuffer result = new StringBuffer();
        result.append("C1G2LLRPCapabilities: \n");
        result.append("\t CanSupportBlockErase: " + this.canSupportBlockErase + '\n');
        result.append("\t CanSupportBlockWrite: " + this.canSupportBlockWrite + '\n');
        result.append("\t MaxNumSelectFiltersPerQuery: " + this.maxNumSelectFiltersPerQuery + '\n');
        return result.toString();
    }

    public String printGeneralDeviceCapabilities() {
        Number antennaId;
        int i;
        StringBuffer result = new StringBuffer();
        result.append("GeneralDeviceCapabilities: \n");
        result.append("\t MaxNumberOfAntennaSupported: " + this.maxNumberOfAntennaSupported + '\n');
        result.append("\t CanSetAntennaProperties: " + this.canSetAntennaProperties + '\n');
        result.append("\t HasUTCClockCapability: " + this.hasUTCClockCapability + '\n');
        result.append("\t DeviceManufactureName: " + this.deviceManufacturerName + '\n');
        result.append("\t ModelName: " + this.modelName + '\n');
        result.append("\t ReaderFirmwareVersion: " + this.readerFirmwareVersion + '\n');
        result.append("\t SupportGPIs: " + this.numGPIs + '\n');
        result.append("\t SupportGPOs: " + this.numGPOs + '\n');
        if (this.receiveSensitivityTable != null && this.receiveSensitivityTable.size() > 0) {
            result.append("\t ReceiveSensitivityTable: \n");
            i = 0;
            while (i < this.receiveSensitivityTable.size()) {
                Map receiveSensitivityTableEntry = (Map)this.receiveSensitivityTable.get(i);
                if (receiveSensitivityTableEntry != null) {
                    Number index = (Number)receiveSensitivityTableEntry.get("Index");
                    Number receiveSensitivityValue = (Number)receiveSensitivityTableEntry.get("ReceiveSensitivityValue");
                    result.append("\t\t Index: " + index + '\n');
                    result.append("\t\t\t ReceiveSensitivityValue: " + receiveSensitivityValue + '\n');
                }
                ++i;
            }
        }
        if (this.perAntennaReceiveSensitivityRange != null && this.perAntennaReceiveSensitivityRange.size() > 0) {
            result.append("\t PerAntennaReceiveSensitivityRange: \n");
            i = 0;
            while (i < this.perAntennaReceiveSensitivityRange.size()) {
                Map perAntennaReceiveSensitivityRangeEntry = (Map)this.perAntennaReceiveSensitivityRange.get(i);
                if (perAntennaReceiveSensitivityRangeEntry != null) {
                    antennaId = (Number)perAntennaReceiveSensitivityRangeEntry.get("AntennaID");
                    Number receiveSensitivityIndexMin = (Number)perAntennaReceiveSensitivityRangeEntry.get("ReceiveSensitivityIndexMin");
                    Number receiveSensitivityIndexMax = (Number)perAntennaReceiveSensitivityRangeEntry.get("ReceiveSensitivityIndexMax");
                    result.append("\t\t AntennaID: " + antennaId + '\n');
                    result.append("\t\t\t ReceiveSensitivityIndexMin: " + receiveSensitivityIndexMin + '\n');
                    result.append("\t\t\t ReceiveSensitivityIndexMax: " + receiveSensitivityIndexMax + '\n');
                }
                ++i;
            }
        }
        if (this.perAntennaAirProtocol != null && this.perAntennaAirProtocol.size() > 0) {
            result.append("\t PerAntennaAirProtocol: \n");
            i = 0;
            while (i < this.perAntennaAirProtocol.size()) {
                Map perAntennaAirProtocolEntry = (Map)this.perAntennaAirProtocol.get(i);
                if (perAntennaAirProtocolEntry != null) {
                    antennaId = (Number)perAntennaAirProtocolEntry.get("AntennaID");
                    result.append("\t\t AntennaID: " + antennaId + '\n');
                    List protocolIds = (List)perAntennaAirProtocolEntry.get("ProtocolIDs");
                    if (protocolIds != null) {
                        int p = 0;
                        while (p < protocolIds.size()) {
                            Number protocolId = (Number)protocolIds.get(p);
                            result.append("\t\t\t ProtocolId: " + protocolId + '\n');
                            ++p;
                        }
                    }
                }
                ++i;
            }
        }
        return result.toString();
    }

    public String printLLRPCapabilities() {
        StringBuffer result = new StringBuffer();
        result.append("LLRPCapabilities: \n");
        result.append("\t CanDoRFSurvey: " + this.canDoRFSurvey + '\n');
        result.append("\t CanReportBufferFillWarning: " + this.canReportBufferFillWarning + '\n');
        result.append("\t SupportsClientRequestOpSpec: " + this.supportsClientRequestOpSpec + '\n');
        result.append("\t CanDoTagInventoryStateAwareSingulation: " + this.canDoTagInventoryStateAwaresingulation + '\n');
        result.append("\t SupportsEventAndReportHolding: " + this.supportsEventAndREportHolding + '\n');
        result.append("\t MaxPriorityLevelSupported: " + this.maxPriorityLevelSupported + '\n');
        result.append("\t ClientRequestOpSpecTimeout: " + this.clientRequestOpSpecTimeout + '\n');
        result.append("\t MaxNumROSpecs: " + this.maxNumROSpecs + '\n');
        result.append("\t MaxNumSpecsPerROSpec: " + this.maxNumSpecsPerROSpecs + '\n');
        result.append("\t MaxNumInventoryParameterSpecsperAISpec: " + this.maxNumInventoryParameterSpecsperAISpec + '\n');
        result.append("\t MaxNumAccessSpecs: " + this.maxNumAccessSpecs + '\n');
        result.append("\t MaxNumOpSpecsPerAccessSpec: " + this.maxNumOpSpecsPerAccessSpec + '\n');
        return result.toString();
    }

    public String printRegulatoryCapabilities() {
        StringBuffer result = new StringBuffer();
        result.append("RegulatoryCapabilities: \n");
        result.append("\t CountryCode: " + this.countryCode + '\n');
        result.append("\t CommunicationsStandard: " + this.communicationsStandard + '\n');
        if (this.uHFBandCapabilities != null) {
            List airProtocolUHFRFModeTableChoice;
            Map frequencyInformation;
            result.append("\tUHFBandCapabilities: \n");
            List transmitPowerLevelTable = (List)this.uHFBandCapabilities.get("TransmitPowerLevelTableEntryParameter");
            if (transmitPowerLevelTable != null) {
                int i = 0;
                while (i < transmitPowerLevelTable.size()) {
                    result.append("\t\tTransmitPowerLevelTable:\n");
                    Map transmitPowerLevelTableEntry = (Map)transmitPowerLevelTable.get(i);
                    Number index = (Number)transmitPowerLevelTableEntry.get("Index");
                    Number transmitPowerValue = (Number)transmitPowerLevelTableEntry.get("TransmitPowerValue");
                    result.append("\t\t\t Index: " + index + '\n');
                    result.append("\t\t\t\t transmitPowerValue: " + transmitPowerValue + '\n');
                    ++i;
                }
            }
            if ((frequencyInformation = (Map)this.uHFBandCapabilities.get("FrequencyInformationParameter")) != null) {
                Map fixedFrequencyTable;
                result.append("\t\tFrequencyInformation:\n");
                Boolean hopping = (Boolean)frequencyInformation.get("Hopping");
                result.append("\t\t\t Hopping:" + hopping + '\n');
                List frequencyHopTable = (List)frequencyInformation.get("FrequencyHopTableParameter");
                if (frequencyHopTable != null) {
                    result.append("\t\t\t frequencyHopTable:\n");
                    int i = 0;
                    while (i < frequencyHopTable.size()) {
                        Map frequencyHopTableEntry = (Map)frequencyHopTable.get(i);
                        Number hopTableId = (Number)frequencyHopTableEntry.get("FrequencyHopTable_HopTableID");
                        result.append("\t\t\t\t HopTableId: " + hopTableId + '\n');
                        List frequencys = (List)frequencyHopTableEntry.get("Frequencys");
                        if (frequencys != null) {
                            int f = 0;
                            while (f < frequencys.size()) {
                                Number frequency = (Number)frequencys.get(f);
                                result.append("\t\t\t\t\t Frequency#" + f + ": " + frequency + '\n');
                                ++f;
                            }
                        }
                        ++i;
                    }
                }
                if ((fixedFrequencyTable = (Map)frequencyInformation.get("FixedFrequencyTableParameter")) != null) {
                    result.append("\t\t\t fixedFrequencyTable:\n");
                    List frequencys = (List)fixedFrequencyTable.get("Frequencys");
                    if (frequencys != null) {
                        int f = 0;
                        while (f < frequencys.size()) {
                            Number frequency = (Number)frequencys.get(f);
                            result.append("\t\t\t\t Frequency#" + f + ": " + frequency + '\n');
                            ++f;
                        }
                    }
                }
            }
            if ((airProtocolUHFRFModeTableChoice = (List)this.uHFBandCapabilities.get("AirProtocolUHFRFModeTableChoice")) != null) {
                result.append("\t\tUHFC1G2RFModeTable:\n");
                int i = 0;
                while (i < airProtocolUHFRFModeTableChoice.size()) {
                    List uHFC1G2RFModeTableEntries;
                    Map uHFC1G2RFModeTable = (Map)airProtocolUHFRFModeTableChoice.get(i);
                    if (uHFC1G2RFModeTable != null && (uHFC1G2RFModeTableEntries = (List)uHFC1G2RFModeTable.get("C1G2UHFRFModeTableEntryParameter")) != null) {
                        int t = 0;
                        while (t < uHFC1G2RFModeTableEntries.size()) {
                            Map uHFC1G2RFModeTableEntry = (Map)uHFC1G2RFModeTableEntries.get(t);
                            if (uHFC1G2RFModeTableEntry != null) {
                                Number modeIdentifier = (Number)uHFC1G2RFModeTableEntry.get("ModeIdentifier");
                                Boolean dRValue = (Boolean)uHFC1G2RFModeTableEntry.get("DRValue");
                                Boolean ePCHAGTCConformance = (Boolean)uHFC1G2RFModeTableEntry.get("EPCHAGTCConformance");
                                Number mValue = (Number)uHFC1G2RFModeTableEntry.get("MValue");
                                Number forwardLinkModulation = (Number)uHFC1G2RFModeTableEntry.get("ForwardLinkModulation");
                                Number spectralMaskIndicator = (Number)uHFC1G2RFModeTableEntry.get("SpectralMaskIndicator");
                                Number bDRValue = (Number)uHFC1G2RFModeTableEntry.get("BDRValue");
                                Number pIEValue = (Number)uHFC1G2RFModeTableEntry.get("PIEValue");
                                Number minTariValue = (Number)uHFC1G2RFModeTableEntry.get("MinTariValue");
                                Number maxTariValue = (Number)uHFC1G2RFModeTableEntry.get("MaxTariValue");
                                Number stepTariValue = (Number)uHFC1G2RFModeTableEntry.get("StepTariValue");
                                result.append("\t\t\t ModeIdentifier:" + modeIdentifier + '\n');
                                result.append("\t\t\t\t DRValue:" + dRValue + '\n');
                                result.append("\t\t\t\t EPCHAGTCConformance:" + ePCHAGTCConformance + '\n');
                                result.append("\t\t\t\t MValue:" + mValue + '\n');
                                result.append("\t\t\t\t ForwardLinkModulation:" + forwardLinkModulation + '\n');
                                result.append("\t\t\t\t SpectralMaskIndicator:" + spectralMaskIndicator + '\n');
                                result.append("\t\t\t\t BDRValue:" + bDRValue + '\n');
                                result.append("\t\t\t\t PIEValue:" + pIEValue + '\n');
                                result.append("\t\t\t\t MinTariValue:" + minTariValue + '\n');
                                result.append("\t\t\t\t MaxTariValue:" + maxTariValue + '\n');
                                result.append("\t\t\t\t StepTariValue:" + stepTariValue + '\n');
                            }
                            ++t;
                        }
                    }
                    ++i;
                }
            }
        }
        return result.toString();
    }
}

