/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.testmanager.ActionContainer;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.TestStatistics;
import org.eclipse.soda.dk.testmanager.action.AbstractAction;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.service.DistributedTestSessionService;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.dk.testmanager.service.TestStatisticsService;
import org.eclipse.soda.sat.core.util.LogUtility;

public class TestScript
implements TestScriptService,
ActionContainer,
Runnable {
    private ScriptRunListenerService scriptListener;
    private Map attributes;
    private TestStatisticsService testStatistics;
    private List actions = new ArrayList();
    private DistributedTestSessionService distributedTestSession;

    public TestScript() {
        this.attributes = new Hashtable();
    }

    public void add(Action action) {
        this.actions.add(action);
        this.testStatistics = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute() throws InterruptedException {
        try {
            try {
                this.scriptListener.scriptRunStarted(this);
                Iterator iter = this.actions.iterator();
                while (iter.hasNext()) {
                    AbstractAction.execute(this, (Action)iter.next());
                }
            }
            catch (RuntimeException e) {
                LogUtility.logError((Object)this, (String)TestManager.DefaultResourceBundle.getString(Integer.toString(7186)), (Throwable)e);
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.getTestStatistics().incrementCount("TEST_SCRIPT_ERROR_COUNT", 1);
                this.scriptListener.scriptRunError(e.toString(), writer.toString());
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.distributedTestSession.close();
            this.scriptListener.scriptRunEnded(this.getTestStatistics());
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.distributedTestSession.close();
            this.scriptListener.scriptRunEnded(this.getTestStatistics());
            return;
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public DistributedTestSessionService getDistributedTestSession() {
        return this.distributedTestSession;
    }

    public ScriptRunListenerService getScriptListener() {
        return this.scriptListener;
    }

    public synchronized TestStatisticsService getTestStatistics() {
        if (this.testStatistics == null) {
            this.testStatistics = new TestStatistics();
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                action.addCounts(this.testStatistics);
            }
        }
        return this.testStatistics;
    }

    public void run(DistributedTestSessionService distributedTestSession, ScriptRunListenerService scriptListener, boolean asynchronous) throws InterruptedException, IOException {
        this.distributedTestSession = distributedTestSession;
        this.scriptListener = scriptListener;
        if (asynchronous) {
            new Thread((Runnable)this, TestManager.DefaultResourceBundle.getString(Integer.toString(7191))).start();
        } else {
            this.execute();
        }
    }

    public void run() {
        try {
            this.execute();
        }
        catch (InterruptedException interruptedException) {}
    }
}

