/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifInternalFuncUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FuncNoSpecificUserDefCheck
extends CifCheck {
    private static final Set<NoSpecificUserDefFunc> ALL_USER_DEF_FUNCS = EnumSet.of(NoSpecificUserDefFunc.INTERNAL, NoSpecificUserDefFunc.EXTERNAL);
    private final Set<NoSpecificUserDefFunc> disalloweds;
    private final List<InternalFunction> internalFunctions = Lists.list();
    private int externalMinReturnValues = 1;
    private int internalMinReturnValues = 1;
    private Integer externalMaxReturnValues = null;
    private Integer internalMaxReturnValues = null;

    public FuncNoSpecificUserDefCheck(Set<NoSpecificUserDefFunc> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public FuncNoSpecificUserDefCheck(NoSpecificUserDefFunc ... disalloweds) {
        this(Arrays.stream(disalloweds).collect(Collectors.toCollection(() -> EnumSet.noneOf(NoSpecificUserDefFunc.class))));
    }

    public FuncNoSpecificUserDefCheck internalFuncReturnValuesLimits(Integer minCount, Integer maxCount) {
        Assert.check((minCount == null || minCount >= 1 ? 1 : 0) != 0, (Object)"Minimum number of return values for internal functions is 1.");
        this.internalMinReturnValues = minCount == null ? 1 : minCount;
        this.internalMaxReturnValues = maxCount;
        Assert.check((this.internalMaxReturnValues == null || this.internalMinReturnValues <= this.internalMaxReturnValues ? 1 : 0) != 0, (Object)"Internal function return value count limits are conflicting.");
        return this;
    }

    public FuncNoSpecificUserDefCheck externalFuncReturnValuesLimits(Integer minCount, Integer maxCount) {
        Assert.check((minCount == null || minCount >= 1 ? 1 : 0) != 0, (Object)"Minimum number of return values for external functions is 1.");
        this.externalMinReturnValues = minCount == null ? 1 : minCount;
        this.externalMaxReturnValues = maxCount;
        Assert.check((this.externalMaxReturnValues == null || this.externalMinReturnValues <= this.externalMaxReturnValues ? 1 : 0) != 0, (Object)"External function return value count limits are conflicting.");
        return this;
    }

    protected void preprocessInternalFunction(InternalFunction func, CifCheckViolations violations) {
        this.checkFunction((Function)func, NoSpecificUserDefFunc.INTERNAL, violations);
        if (!this.disalloweds.contains((Object)NoSpecificUserDefFunc.INTERNAL) && this.disalloweds.contains((Object)NoSpecificUserDefFunc.INTERNAL_RECURSIVE)) {
            this.internalFunctions.add(func);
        }
    }

    protected void preprocessExternalFunction(ExternalFunction func, CifCheckViolations violations) {
        this.checkFunction((Function)func, NoSpecificUserDefFunc.EXTERNAL, violations);
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        CifInternalFuncUtils.OrderInternalFunctions orderer;
        if (!this.disalloweds.contains((Object)NoSpecificUserDefFunc.INTERNAL) && this.disalloweds.contains((Object)NoSpecificUserDefFunc.INTERNAL_RECURSIVE) && !this.internalFunctions.isEmpty() && (orderer = new CifInternalFuncUtils.OrderInternalFunctions()).computeOrder(this.internalFunctions, true) == null) {
            List cycle = orderer.getCycle();
            if (cycle.size() == 1) {
                violations.add((PositionObject)cycle.get(0), "Internal user-defined function calls itself recursively", new Object[0]);
            } else {
                String cyclePath = cycle.stream().map(intFunc -> CifTextUtils.getAbsName((PositionObject)intFunc, (boolean)false)).collect(Collectors.joining(" -> "));
                String msg = Strings.fmt((String)"Internal user-defined function is involved in a recursive call cycle: %s -> %s -> ..", (Object[])new Object[]{cyclePath, CifTextUtils.getAbsName((PositionObject)((PositionObject)cycle.get(0)), (boolean)false)});
                for (InternalFunction intFunc2 : cycle) {
                    violations.add((PositionObject)intFunc2, msg, new Object[0]);
                }
            }
        }
    }

    private void checkFunction(Function func, NoSpecificUserDefFunc funcKind, CifCheckViolations violations) {
        String funcText;
        String errDesc;
        if (this.disalloweds.contains((Object)funcKind)) {
            if (this.disalloweds.containsAll(ALL_USER_DEF_FUNCS)) {
                violations.add((PositionObject)func, "Function is a user-defined function", new Object[0]);
                return;
            }
            String funcText2 = funcKind == NoSpecificUserDefFunc.INTERNAL ? "internal" : "external";
            violations.add((PositionObject)func, "Function is an %s user-defined function", funcText2);
            return;
        }
        if (this.disalloweds.contains((Object)NoSpecificUserDefFunc.NO_PARAMETER) && func.getParameters().isEmpty()) {
            violations.add((PositionObject)func, "Function is a user-defined function without parameters", new Object[0]);
        }
        if (func instanceof InternalFunction) {
            errDesc = FuncNoSpecificUserDefCheck.reportNumReturnValues(func, this.internalMinReturnValues, this.internalMaxReturnValues);
            funcText = "Internal";
        } else {
            errDesc = FuncNoSpecificUserDefCheck.reportNumReturnValues(func, this.externalMinReturnValues, this.externalMaxReturnValues);
            funcText = "External";
        }
        if (errDesc != null) {
            violations.add((PositionObject)func, "%s user-defined function %s", funcText, errDesc);
        }
    }

    private static String reportNumReturnValues(Function func, int minLimit, Integer maxLimit) {
        int numReturnValues = func.getReturnTypes().size();
        if (numReturnValues < minLimit) {
            return Strings.adjustForPlurals((String)"has less than {num} return value{p '' s}", (int[])new int[]{minLimit});
        }
        if (maxLimit != null && numReturnValues > maxLimit) {
            return Strings.adjustForPlurals((String)"has more than {num} return value{p '' s}", (int[])new int[]{maxLimit});
        }
        return null;
    }

    public static enum NoSpecificUserDefFunc {
        INTERNAL,
        EXTERNAL,
        NO_PARAMETER,
        INTERNAL_RECURSIVE;

    }
}

