/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgNameUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SvgUtils {
    private SvgUtils() {
    }

    public static Document loadSvgFile(String svgAbsPath) {
        try {
            return SvgUtils.loadSvgFileInternal(svgAbsPath);
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"SVG image file \"%s\" could not be found, is a directory, or for some other reason could not be opened for reading.", (Object[])new Object[]{svgAbsPath});
            throw new SvgException(msg, ex);
        }
        catch (DOMException ex) {
            String msg = Strings.fmt((String)"SVG image file \"%s\" is not an SVG file, is an invalid SVG file, or contains unsupported SVG features.", (Object[])new Object[]{svgAbsPath});
            throw new SvgException(msg, ex);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"SVG image file \"%s\" could not be read, is empty, is incomplete, is not an SVG file, or is an invalid SVG file.", (Object[])new Object[]{svgAbsPath});
            throw new SvgException(msg, ex);
        }
    }

    public static Document loadSvgFileInternal(String svgAbsPath) throws IOException {
        InputStream svgStream;
        Object uri;
        if (PlatformUriUtils.isPlatformUri((String)svgAbsPath)) {
            try {
                uri = URI.createURI((String)svgAbsPath);
            }
            catch (IllegalArgumentException ex) {
                String msg = Strings.fmt((String)"Platform URI \"%s\" is invalid.", (Object[])new Object[]{svgAbsPath});
                throw new IOException(msg, ex);
            }
            if (!PlatformUriUtils.exists((String)svgAbsPath)) {
                String msg = Strings.fmt((String)"Resource \"%s\" not found.", (Object[])new Object[]{svgAbsPath});
                throw new FileNotFoundException(msg);
            }
            URIConverter converter = URIConverter.INSTANCE;
            svgStream = converter.createInputStream(uri);
        } else {
            svgStream = new FileInputStream(svgAbsPath);
        }
        uri = PlatformUriUtils.isPlatformUri((String)svgAbsPath) ? svgAbsPath : Paths.createJavaURI((String)svgAbsPath).toString();
        Document document = null;
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            Document document2 = document = factory.createDocument((String)uri, svgStream);
            return document2;
        }
        finally {
            block12: {
                try {
                    svgStream.close();
                }
                catch (IOException ex) {
                    if (document == null) break block12;
                    throw ex;
                }
            }
        }
    }

    public static boolean isCssAttr(Element elem, String attrName) {
        Document doc = elem.getOwnerDocument();
        SVGOMDocument svgDoc = (SVGOMDocument)doc;
        CSSEngine cssEngine = svgDoc.getCSSEngine();
        int idx = cssEngine.getPropertyIndex(attrName);
        return idx != -1;
    }

    public static Text getTextNode(Element elem) {
        Element curElem = elem;
        while (true) {
            Element child = null;
            int subElemCount = 0;
            NodeList children = curElem.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i) instanceof Text) {
                    return (Text)children.item(i);
                }
                if (children.item(i) instanceof Element) {
                    ++subElemCount;
                    child = (Element)children.item(i);
                }
                ++i;
            }
            if (subElemCount != true) break;
            Assert.notNull(child);
            curElem = child;
        }
        return null;
    }

    public static String getSvgElementId(Element elem) {
        NamedNodeMap attrs = elem.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.isId()) {
                return attr.getValue();
            }
            ++i;
        }
        return null;
    }

    public static Pair<String, String> renameElements(Element root, String prefix, String postfix, Document doc) {
        NamedNodeMap attrs = root.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.isId()) {
                String oldId = attr.getValue();
                String newId = prefix + oldId + postfix;
                if (doc != null && doc.getElementById(newId) != null) {
                    return Pair.pair((Object)oldId, (Object)newId);
                }
                attr.setValue(newId);
                break;
            }
            ++i;
        }
        NodeList children = root.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Element childElem;
            Pair<String, String> rslt;
            Node child = children.item(i2);
            if (child.getNodeType() == 1 && (rslt = SvgUtils.renameElements(childElem = (Element)child, prefix, postfix, doc)) != null) {
                return rslt;
            }
            ++i2;
        }
        return null;
    }

    public static boolean copy(Document doc, String id, String pre, String post, String svgPath) {
        return SvgUtils.copy(doc, id, pre, post, svgPath, true);
    }

    public static boolean copy(Document doc, String id, String pre, String post, String svgPath, boolean errNotExist) {
        Element elem = doc.getElementById(id);
        if (elem == null) {
            if (!errNotExist) {
                return false;
            }
            String msg = Strings.fmt((String)"Could not find an SVG element with id \"%s\" in SVG file \"%s\".", (Object[])new Object[]{id, svgPath});
            throw new InvalidInputException(msg);
        }
        if (pre.isEmpty() && post.isEmpty()) {
            String msg = Strings.fmt((String)"Copying the SVG element with id \"%s\" in SVG file \"%s\" failed, as both the prefix and postfix are empty.", (Object[])new Object[]{id, svgPath, pre, post});
            throw new InvalidInputException(msg);
        }
        if (!SvgNameUtils.isValidSvgPrefixName(pre)) {
            String msg = Strings.fmt((String)"Copying the SVG element with id \"%s\" in SVG file \"%s\" failed, as prefix \"%s\" is not a valid SVG name prefix.", (Object[])new Object[]{id, svgPath, pre});
            throw new InvalidInputException(msg);
        }
        if (!SvgNameUtils.isValidSvgPostfixName(post)) {
            String msg = Strings.fmt((String)"Copying the SVG element with id \"%s\" in SVG file \"%s\" failed, as postfix \"%s\" is not a valid SVG name postfix.", (Object[])new Object[]{id, svgPath, pre});
            throw new InvalidInputException(msg);
        }
        Node parent = elem.getParentNode();
        if (parent.getNodeType() != 1) {
            String msg = Strings.fmt((String)"Copying the SVG element with id \"%s\" in SVG file \"%s\" is not supported, as the element is the root element of the SVG file.", (Object[])new Object[]{id, svgPath});
            throw new InvalidInputException(msg);
        }
        Element copy = (Element)elem.cloneNode(true);
        Pair<String, String> duplIds = SvgUtils.renameElements(copy, pre, post, doc);
        if (duplIds != null) {
            String msg = Strings.fmt((String)"Copying the SVG element with id \"%s\" in SVG file \"%s\" resulted in a copy of the SVG element with id \"%s\" to id \"%s\", which already exists.", (Object[])new Object[]{id, svgPath, duplIds.left, duplIds.right});
            throw new InvalidInputException(msg);
        }
        Element parentElement = (Element)parent;
        parentElement.insertBefore(copy, elem);
        return true;
    }

    public static void move(Document doc, BridgeContext bridgeContext, String id, double x, double y, String svgPath) {
        Element elem = doc.getElementById(id);
        if (elem == null) {
            String msg = Strings.fmt((String)"Could not find an SVG element with id \"%s\" in SVG file \"%s\".", (Object[])new Object[]{svgPath});
            throw new InvalidInputException(msg);
        }
        GraphicsNode node = bridgeContext.getGraphicsNode((Node)elem);
        if (node == null) {
            String msg = Strings.fmt((String)"Moving the SVG element with id \"%s\" in SVG file \"%s\" failed, as the element does not have a graphical representation.", (Object[])new Object[]{id, svgPath});
            throw new InvalidInputException(msg);
        }
        Rectangle2D rect = node.getBounds();
        Point2D.Double nxy = new Point2D.Double(rect.getX(), rect.getY());
        AffineTransform glob = node.getGlobalTransform();
        glob.transform(nxy, nxy);
        double nx = nxy.x;
        double ny = nxy.y;
        double[] abcd = new double[4];
        glob.getMatrix(abcd);
        double a = abcd[0];
        double b = abcd[1];
        double c = abcd[2];
        double d = abcd[3];
        if (a == 0.0) {
            String msg = Strings.fmt((String)"Moving the SVG element with id \"%s\" in SVG file \"%s\" failed, due to conflicting existing transformations on the element itself, or one of its ancestors.", (Object[])new Object[]{id, svgPath});
            throw new InvalidInputException(msg);
        }
        double dbca = d - b * c / a;
        if (dbca == 0.0) {
            String msg = Strings.fmt((String)"Moving the SVG element with id \"%s\" in SVG file \"%s\" failed, due to conflicting existing transformations on the element itself, or one of its ancestors.", (Object[])new Object[]{id, svgPath});
            throw new InvalidInputException(msg);
        }
        double dy = (y - ny - b * (x - nx) / a) / dbca;
        double dx = (x - nx) / a - c / a * dy;
        Object value = elem.getAttribute("transform");
        if (!((String)value).isEmpty()) {
            value = (String)value + " ";
        }
        value = (String)value + Strings.fmt((String)"translate(%f,%f)", (Object[])new Object[]{dx, dy});
        elem.setAttribute("transform", (String)value);
    }
}

