/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class RemoveRequirements
implements CifToCifTransformation {
    public boolean removeReqAuts = true;
    public boolean removeStateEvtExclReqInvs = true;
    public boolean removeStateReqInvs = true;
    private final Set<String> problemMessages = Sets.set();
    private Map<Automaton, String> absReqAutNames;

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Removing requirements from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.absReqAutNames = Maps.map();
        this.removeRequirements((ComplexComponent)spec);
        this.checkRefs(spec);
        if (!this.problemMessages.isEmpty()) {
            String msg = "Removing requirements from a CIF specification failed due to the remaining part of the specification using declarations that are declared in the requirement automata that are to be removed, or a location of a requirement automaton contains invariants that cannot be removed:\n - " + String.join((CharSequence)"\n - ", Sets.sortedstrings(this.problemMessages));
            throw new CifToCifPreconditionException(msg);
        }
        CifControllerPropertiesAnnotationUtils.remove((Specification)spec);
    }

    private void removeRequirements(ComplexComponent comp) {
        Iterator invIter = comp.getInvariants().iterator();
        while (invIter.hasNext()) {
            Invariant inv = (Invariant)invIter.next();
            if (!this.shouldRemoveInvariant(inv)) continue;
            invIter.remove();
        }
        if (comp instanceof Group) {
            EList children = ((Group)comp).getComponents();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                Component child = (Component)childIter.next();
                if (child instanceof Automaton) {
                    SupKind kind = ((Automaton)child).getKind();
                    if (kind == SupKind.REQUIREMENT && this.removeReqAuts) {
                        this.moveInvariantsFromAut((Automaton)child);
                        this.absReqAutNames.put((Automaton)child, CifTextUtils.getAbsName((PositionObject)child));
                        childIter.remove();
                        continue;
                    }
                    this.removeRequirements((ComplexComponent)child);
                }
                if (!(child instanceof Group)) continue;
                this.removeRequirements((ComplexComponent)child);
            }
        }
        if (comp instanceof Automaton) {
            for (Location loc : ((Automaton)comp).getLocations()) {
                invIter = loc.getInvariants().iterator();
                while (invIter.hasNext()) {
                    if (!this.shouldRemoveInvariant((Invariant)invIter.next())) continue;
                    invIter.remove();
                }
            }
        }
    }

    private boolean shouldRemoveInvariant(Invariant inv) {
        if (inv.getSupKind() != SupKind.REQUIREMENT) {
            return false;
        }
        switch (inv.getInvKind()) {
            case STATE: {
                if (!this.removeStateReqInvs) break;
                return true;
            }
            case EVENT_NEEDS: 
            case EVENT_DISABLES: {
                if (!this.removeStateEvtExclReqInvs) break;
                return true;
            }
        }
        return false;
    }

    private void moveInvariantsFromAut(Automaton aut) {
        Assert.check((boolean)(aut.eContainer() instanceof ComplexComponent));
        ComplexComponent parent = (ComplexComponent)aut.eContainer();
        Iterator invIter = aut.getInvariants().iterator();
        while (invIter.hasNext()) {
            Invariant inv = (Invariant)invIter.next();
            if (this.shouldRemoveInvariant(inv)) continue;
            invIter.remove();
            parent.getInvariants().add((Object)inv);
        }
        for (Location loc : aut.getLocations()) {
            for (Invariant inv : loc.getInvariants()) {
                if (this.shouldRemoveInvariant(inv)) continue;
                String locTxt = loc.getName() == null ? "Location" : Strings.fmt((String)"Location \"%s\"", (Object[])new Object[]{loc.getName()});
                String kindTxt = CifTextUtils.kindToStr((SupKind)inv.getSupKind());
                String msg = Strings.fmt((String)"%s of requirement automaton \"%s\" contains a %s invariant.", (Object[])new Object[]{locTxt, CifTextUtils.getAbsName((PositionObject)aut), kindTxt});
                this.problemMessages.add(msg);
            }
        }
    }

    private void checkRefs(Specification spec) {
        Map problems = EcoreUtil.ExternalCrossReferencer.find((EObject)spec);
        if (problems.isEmpty()) {
            return;
        }
        for (Map.Entry problem : problems.entrySet()) {
            String relTxt;
            PositionObject removedObj = (PositionObject)problem.getKey();
            Collection problemRefs = (Collection)problem.getValue();
            EObject removedRootObj = EcoreUtil.getRootContainer((EObject)removedObj);
            Automaton removedReqAut = (Automaton)removedRootObj;
            String absReqName = this.absReqAutNames.get(removedReqAut);
            Assert.notNull((Object)absReqName);
            if (removedReqAut == removedObj) {
                relTxt = null;
            } else {
                PositionObject scope = CifScopeUtils.getScope((PositionObject)removedObj);
                Assert.check((scope == removedReqAut ? 1 : 0) != 0);
                relTxt = CifTextUtils.getName((PositionObject)removedObj);
                relTxt = CifTextUtils.escapeIdentifier((String)relTxt);
            }
            for (EStructuralFeature.Setting problemRef : problemRefs) {
                PositionObject scope;
                PositionObject refObj = (PositionObject)problemRef.getEObject();
                PositionObject positionObject = scope = CifScopeUtils.isScope((PositionObject)refObj) ? refObj : CifScopeUtils.getScope((PositionObject)refObj);
                if (scope instanceof ProjectionExpression) {
                    scope = CifScopeUtils.getScope((PositionObject)scope);
                }
                ComplexComponent scopeComp = (ComplexComponent)scope;
                String scopeTxt = CifTextUtils.getComponentText2((ComplexComponent)scopeComp);
                String declTxt = relTxt == null ? "" : Strings.fmt((String)"contains declaration \"%s\" that ", (Object[])new Object[]{relTxt});
                String msg = Strings.fmt((String)"Requirement automaton \"%s\" %sis used somewhere in %s.", (Object[])new Object[]{absReqName, declTxt, scopeTxt});
                this.problemMessages.add(msg);
            }
        }
    }
}

