/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.simulator.options;

import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class OutputDirectoryOption
extends Option<String> {
    public static String getPath() {
        return (String)Options.get(OutputDirectoryOption.class);
    }

    public OutputDirectoryOption() {
        super("Directory", "Output directory for generated Java files", null, "directory", "DIR", true);
    }

    public String getDefault() {
        return null;
    }

    public String parseValue(String optName, String value) {
        return value;
    }

    public String[] getCmdLine(Object value) {
        if (value == null) {
            return new String[0];
        }
        return new String[]{"--directory=" + (String)value};
    }

    public OptionGroup<String> createOptionGroup(Composite page) {
        return new OptionGroup<String>(page, Options.getInstance(OutputDirectoryOption.class)){
            Label fileLabel;
            Text fileText;

            protected void addComponents(Group group) {
                this.fileLabel = new Label((Composite)group, 0);
                this.fileLabel.setText("Directory path:");
                this.fileText = new Text((Composite)group, 2052);
                this.layoutGeneric(new Object[]{new Control[]{this.fileLabel, this.fileText}}, 0);
            }

            public String getDescription() {
                return "The output directory path.";
            }

            public void setToValue(String value) {
                this.fileText.setText(value == null ? "" : value);
            }

            public String[] getCmdLine() {
                return new String[]{"--directory=" + this.fileText.getText()};
            }
        };
    }
}

