/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.eventbased.ObserverCheck;
import org.eclipse.escet.cif.eventbased.apps.conversion.ApplicationHelper;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBasedPreChecker;
import org.eclipse.escet.cif.eventbased.apps.options.ObservedEventsOption;
import org.eclipse.escet.cif.eventbased.apps.options.ReportFileOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class ObserverCheckApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ObserverCheckApplication app = new ObserverCheckApplication();
        app.run(args, true);
    }

    public ObserverCheckApplication() {
    }

    public ObserverCheckApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(ObservedEventsOption.class));
        options.add(Options.getInstance(ReportFileOption.class));
        return new OptionCategory("Observer check", "CIF event-based observer check options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(ObserverCheckApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based observer check tool.";
        return new OptionCategory("Event-based observer check options", optDesc, subPages, options);
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String rsltMsg;
        boolean exitCode;
        Set<Event> badEvents;
        Set<Event> observables;
        block18: {
            Automaton aut;
            block17: {
                ConvertToEventBased cte;
                block16: {
                    String absSpecPath;
                    Specification spec;
                    block15: {
                        OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                        spec = (Specification)((CifReader)new CifReader().init()).read();
                        absSpecPath = Paths.resolve((String)InputFileOption.getPath());
                        if (!this.isTerminationRequested()) break block15;
                        return 0;
                    }
                    new ElimComponentDefInst().transform(spec);
                    boolean allowPlainEvents = true;
                    boolean allowNonDeterminism = true;
                    ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata expectedNumberOfAutomata = ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata.EXACTLY_ONE_AUTOMATON;
                    EnumSet<SupKind> disallowedAutSupKinds = EnumSet.noneOf(SupKind.class);
                    boolean requireAutHasInitLoc = false;
                    boolean requireReqSubsetPlantAlphabet = false;
                    boolean requireAutMarkedAndNonMarked = false;
                    Termination termination = () -> this.isTerminationRequested();
                    ConvertToEventBasedPreChecker checker = new ConvertToEventBasedPreChecker(allowPlainEvents, allowNonDeterminism, expectedNumberOfAutomata, disallowedAutSupKinds, requireAutHasInitLoc, requireReqSubsetPlantAlphabet, requireAutMarkedAndNonMarked, termination);
                    checker.reportPreconditionViolations(spec, absSpecPath, this.getAppName());
                    OutputProvider.dbg((String)"Converting to internal representation...");
                    cte = new ConvertToEventBased();
                    cte.convertSpecification(spec);
                    if (!this.isTerminationRequested()) break block16;
                    return 0;
                }
                OutputProvider.dbg((String)"Applying observer check...");
                aut = cte.automata.get(0);
                String[] obsNms = ObservedEventsOption.getEvents();
                observables = ApplicationHelper.selectEvents(obsNms, aut.alphabet);
                if (!this.isTerminationRequested()) break block17;
                return 0;
            }
            badEvents = ObserverCheck.doObserverCheck(aut, observables);
            if (!this.isTerminationRequested()) break block18;
            return 0;
        }
        try {
            String outPath = "_observation.txt";
            outPath = ReportFileOption.getDerivedPath(".cif", outPath);
            OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
            String absOutPath = Paths.resolve((String)outPath);
            exitCode = !badEvents.isEmpty();
            String result = !exitCode ? "HOLDS" : "FAILS";
            rsltMsg = Strings.fmt((String)"Observer check %s in file \"%s\". See \"%s\" for details.", (Object[])new Object[]{result, InputFileOption.getPath(), outPath});
            FileAppStream stream = new FileAppStream(outPath, absOutPath);
            OutputProvider.dbg((String)rsltMsg);
            stream.printf("Observer check %s in file \"%s\"\n", new Object[]{result, InputFileOption.getPath()});
            stream.printf("for observable events", new Object[0]);
            boolean first = true;
            for (Event evt : observables) {
                if (!first) {
                    stream.printf(",", new Object[0]);
                }
                stream.printf(" \"%s\"", new Object[]{evt.name});
                first = false;
            }
            stream.printf(".\n", new Object[0]);
            first = true;
            for (Event evt : badEvents) {
                if (first) {
                    if (badEvents.size() == 1) {
                        stream.printf("\nEvent that invalidates ", new Object[0]);
                    } else {
                        stream.printf("\nEvents that invalidate ", new Object[0]);
                    }
                    stream.printf("the observer property:", new Object[0]);
                    first = false;
                } else {
                    stream.printf(",", new Object[0]);
                }
                stream.printf(" \"%s\"", new Object[]{evt.name});
            }
            if (!first) {
                stream.printf(".\n", new Object[0]);
            }
            stream.close();
        }
        catch (ApplicationException e) {
            String msg = Strings.fmt((String)"Failed to apply observer check for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
            throw new ApplicationException(msg, (Throwable)e);
        }
        if (!exitCode) {
            return 0;
        }
        throw new InvalidInputException(rsltMsg);
    }

    public String getAppName() {
        return "CIF observer check tool";
    }

    public String getAppDescription() {
        return "Verifies whether an automaton can act as an observer of occurrences of observable events.";
    }
}

