/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.eclipse.ui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.escet.common.eclipse.ui.G2dSwtPainter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class G2dSwtCanvas
extends Canvas
implements PaintListener,
G2dSwtPainter {
    private static final boolean DRAW_PAINT_COUNT = false;
    private int paintCount = 0;
    private final List<G2dSwtPainter> painters = new CopyOnWriteArrayList<G2dSwtPainter>();

    public G2dSwtCanvas(Composite parent) {
        this(parent, 0x140000);
    }

    public G2dSwtCanvas(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this);
    }

    public void addPainter(G2dSwtPainter painter) {
        this.painters.add(painter);
    }

    public void removePainter(G2dSwtPainter painter) {
        this.painters.remove(painter);
    }

    public final void paintControl(PaintEvent e) {
        ++this.paintCount;
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        byte[] imgData = this.getImageToPaint(w, h);
        PaletteData pal = new PaletteData(255, 65280, 0xFF0000);
        ImageData data = new ImageData(w, h, 24, pal, w * 3, imgData);
        Image img = new Image((Device)this.getDisplay(), data);
        e.gc.drawImage(img, 0, 0);
        img.dispose();
    }

    public byte[] getImageToPaint(int width, int height) {
        return this.paintInMemory(width, height);
    }

    public byte[] paintInMemory(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 5);
        Graphics2D g = this.createGraphics(image);
        this.paint(g, width, height);
        for (G2dSwtPainter painter : this.painters) {
            painter.paint(g, width, height);
        }
        g.dispose();
        DataBuffer buf = image.getRaster().getDataBuffer();
        DataBufferByte bbuf = (DataBufferByte)buf;
        byte[] imgData = bbuf.getData();
        return imgData;
    }

    protected Graphics2D createGraphics(BufferedImage image) {
        return image.createGraphics();
    }
}

