/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Objects;
import org.eclipse.escet.common.java.Strings;

public class Assert {
    private Assert() {
    }

    public static void check(boolean condition) {
        if (condition) {
            return;
        }
        throw new AssertionError();
    }

    public static void check(boolean condition, Object msg) {
        if (condition) {
            return;
        }
        throw new AssertionError((Object)String.valueOf(msg));
    }

    public static void areEqual(Object value1, Object value2) {
        if (Objects.equals(value1, value2)) {
            return;
        }
        throw new AssertionError((Object)Strings.fmt("Values are not equal: '%s' and '%s'", value1, value2));
    }

    public static void areEqual(Object value1, Object value2, Object msg) {
        if (Objects.equals(value1, value2)) {
            return;
        }
        throw new AssertionError(String.valueOf(msg), (Throwable)((Object)new AssertionError((Object)Strings.fmt("Values are not equal: '%s' and '%s'", value1, value2))));
    }

    public static void implies(boolean left, boolean right) {
        if (!left || right) {
            return;
        }
        throw new AssertionError((Object)Strings.fmt("'%s => %s' doesn't hold", left, right));
    }

    public static void implies(boolean left, boolean right, Object msg) {
        if (!left || right) {
            return;
        }
        throw new AssertionError(String.valueOf(msg), (Throwable)((Object)new AssertionError((Object)Strings.fmt("'%s => %s' doesn't hold", left, right))));
    }

    public static void ifAndOnlyIf(boolean left, boolean right) {
        if (left == right) {
            return;
        }
        throw new AssertionError((Object)Strings.fmt("'%s <=> %s' doesn't hold", left, right));
    }

    public static void ifAndOnlyIf(boolean left, boolean right, Object msg) {
        if (left == right) {
            return;
        }
        throw new AssertionError(String.valueOf(msg), (Throwable)((Object)new AssertionError((Object)Strings.fmt("'%s <=> %s' doesn't hold", left, right))));
    }

    public static void fail() {
        throw new AssertionError();
    }

    public static void fail(Object msg) {
        throw new AssertionError((Object)String.valueOf(msg));
    }

    public static void notNull(Object value) {
        if (value != null) {
            return;
        }
        throw new AssertionError();
    }

    public static void notNull(Object value, Object msg) {
        if (value != null) {
            return;
        }
        throw new AssertionError((Object)String.valueOf(msg));
    }
}

