/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.linking;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;

public class ImportAwareHyperlinkHelper
extends HyperlinkHelper {
    @Inject
    ImportHelpers importHelpers;
    @Inject
    Provider<XtextHyperlink> hyperlinkProvider;

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && parseResult.getRootNode() != null) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset);
            Region region = new Region(leaf.getOffset(), leaf.getLength());
            AbstractRule leafRule = null;
            if (leaf.getGrammarElement() instanceof RuleCall) {
                leafRule = ((RuleCall)leaf.getGrammarElement()).getRule();
            }
            AbstractRule parentRule = null;
            if (leaf.getParent().getGrammarElement() instanceof RuleCall) {
                parentRule = ((RuleCall)leaf.getParent().getGrammarElement()).getRule();
            }
            if (parentRule != null && (parentRule.getName().equals("FQN") || parentRule.getName().equals("ImportedFQN"))) {
                QualifiedName fqn = this.importHelpers.toFQN(leaf.getParent().getText().trim());
                IScope scope = this.importHelpers.getVisibleScope((Resource)resource, null);
                IEObjectDescription candidate = scope.getSingleElement(fqn);
                if (candidate != null) {
                    this.createHyperlinksTo(resource, region, candidate.getEObjectOrProxy(), acceptor);
                }
            } else if (parentRule != null && leafRule != null && parentRule.getName().equals("Import") && leafRule.getName().equals("STRING")) {
                String text = leaf.getText().substring(1, leaf.getText().length() - 1);
                String uritext = this.importHelpers.getUriResolver().resolve(text, (Resource)resource);
                if (uritext != null) {
                    try {
                        XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
                        result.setHyperlinkText(uritext);
                        result.setHyperlinkRegion(region);
                        result.setURI(URI.createURI((String)uritext));
                        acceptor.accept((IHyperlink)result);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }
}

