/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.Documentation;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.converter.BaseConverterService;
import org.eclipse.etrice.core.common.converter.CCStringConverter;
import org.eclipse.etrice.core.common.formatting2.BaseFormatter;
import org.eclipse.etrice.core.common.formatting2.CCStringReplacer;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ProtocolSemantics;
import org.eclipse.etrice.core.fsm.fSM.SemanticsRule;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.services.FSMGrammarAccess;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FSMFormatter
extends BaseFormatter {
    @Inject
    @Extension
    private FSMGrammarAccess _fSMGrammarAccess;
    @Inject
    private BaseConverterService converterService;

    public void formatAllByKeywords(EObject it, @Extension IFormattableDocument document) {
        super.formatAllByKeywords(it, document);
        Consumer<ISemanticRegion> consumer = it_1 -> {
            Procedures.Procedure1 procedure1 = it_2 -> it_2.oneSpace();
            document.surround(it_1, procedure1);
        };
        this.textRegionExtensions.allRegionsFor(it).keywords(new String[]{"->", "extends", "=", "or", "|"}).forEach(consumer);
    }

    protected EObject prependDefaultNewLines(EObject it, @Extension IFormattableDocument document) {
        EObject eObject = null;
        if (this.textRegionExtensions.previousHiddenRegion(it) != null && this.textRegionExtensions.previousHiddenRegion(it).getLineCount() > 2) {
            Procedures.Procedure1 procedure1 = it_1 -> it_1.setNewLines(2);
            eObject = document.prepend(it, procedure1);
        } else {
            Procedures.Procedure1 procedure1 = it_1 -> it_1.newLine();
            eObject = document.prepend(it, procedure1);
        }
        return eObject;
    }

    protected ISemanticRegion prependDefaultNewLines(ISemanticRegion it, @Extension IFormattableDocument document) {
        boolean bl;
        ISemanticRegion iSemanticRegion = null;
        int n = it.getPreviousHiddenRegion().getLineCount();
        boolean bl2 = bl = n > 2;
        if (bl) {
            Procedures.Procedure1 procedure1 = it_1 -> it_1.setNewLines(2);
            iSemanticRegion = document.prepend(it, procedure1);
        } else {
            Procedures.Procedure1 procedure1 = it_1 -> it_1.newLine();
            iSemanticRegion = document.prepend(it, procedure1);
        }
        return iSemanticRegion;
    }

    protected void _format(StateGraph it, @Extension IFormattableDocument document) {
        Consumer<EObject> consumer = it_1 -> this.prependDefaultNewLines((EObject)it_1, document);
        it.eContents().forEach(consumer);
        Consumer<EObject> consumer2 = it_1 -> document.format(it_1);
        it.eContents().forEach(consumer2);
    }

    protected void _format(State it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> consumer = it_1 -> {
            this.prependDefaultNewLines((ISemanticRegion)it_1, document);
            Procedures.Procedure1 procedure1 = it_2 -> it_2.oneSpace();
            document.append(it_1, procedure1);
        };
        this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{"entry", "exit", "do", "subgraph"}).forEach(consumer);
        Consumer<EObject> consumer2 = it_1 -> document.format(it_1);
        it.eContents().forEach(consumer2);
    }

    protected void _format(TransitionBase it, @Extension IFormattableDocument document) {
        Object object;
        Consumer<ISemanticRegion> consumer = it_1 -> {
            this.prependDefaultNewLines((ISemanticRegion)it_1, document);
            Procedures.Procedure1 procedure1 = it_2 -> it_2.oneSpace();
            document.append(it_1, procedure1);
        };
        this.textRegionExtensions.regionFor((EObject)it).keywords(new String[]{"action", "guard", "cond", "triggers"}).forEach(consumer);
        if (it instanceof TriggeredTransition) {
            object = it_1 -> it_1.newLine();
            document.prepend((EObject)((Trigger)IterableExtensions.head(((TriggeredTransition)it).getTriggers())), object);
            Consumer<Trigger> consumer2 = it_1 -> {
                Procedures.Procedure1 procedure1 = it_2 -> it_2.oneSpace();
                document.prepend((EObject)it_1, procedure1);
            };
            IterableExtensions.tail(((TriggeredTransition)it).getTriggers()).forEach(consumer2);
        }
        object = it_1 -> document.format(it_1);
        it.eContents().forEach((Consumer)object);
    }

    protected void _format(Trigger it, @Extension IFormattableDocument document) {
        Consumer<Pair> consumer = it_1 -> {
            Procedures.Procedure1 procedure1 = it_2 -> it_2.noSpace();
            document.interior(it_1, procedure1);
        };
        this.textRegionExtensions.regionFor((EObject)it).keywordPairs("<", ">").forEach(consumer);
        Consumer<EObject> consumer2 = it_1 -> document.format(it_1);
        it.eContents().forEach(consumer2);
    }

    protected void _format(ProtocolSemantics it, @Extension IFormattableDocument document) {
        Consumer<SemanticsRule> consumer = it_1 -> this.prependDefaultNewLines((EObject)it_1, document);
        it.getRules().forEach(consumer);
        Consumer<EObject> consumer2 = it_1 -> document.format(it_1);
        it.eContents().forEach(consumer2);
    }

    protected void _format(DetailCode detailcode, @Extension IFormattableDocument document) {
        ISemanticRegion ccRegion = this.textRegionExtensions.regionFor((EObject)detailcode).assignment(this._fSMGrammarAccess.getDetailCodeAccess().getLinesAssignment_0_1());
        if (ccRegion != null) {
            Procedures.Procedure1 procedure1 = it -> it.oneSpace();
            document.prepend((EObject)detailcode, procedure1);
            boolean bl = this.textRegionExtensions.isMultiline((EObject)detailcode);
            if (bl) {
                CCStringConverter cCStringConverter = this.converterService.getCC_StringConverter();
                CCStringReplacer cCStringReplacer = new CCStringReplacer(document, (ITextSegment)ccRegion, cCStringConverter);
                document.addReplacer((ITextReplacer)cCStringReplacer);
            }
        } else {
            Consumer<ISemanticRegion> consumer = it -> {
                Procedures.Procedure1 procedure1 = it_1 -> it_1.newLine();
                document.prepend(it, procedure1);
            };
            this.textRegionExtensions.regionFor((EObject)detailcode).assignments(new Assignment[]{this._fSMGrammarAccess.getDetailCodeAccess().getLinesAssignment_1_1()}).forEach(consumer);
        }
    }

    public void format(Object it, IFormattableDocument document) {
        if (it instanceof State) {
            this._format((State)it, document);
            return;
        }
        if (it instanceof XtextResource) {
            this._format((XtextResource)it, document);
            return;
        }
        if (it instanceof TransitionBase) {
            this._format((TransitionBase)it, document);
            return;
        }
        if (it instanceof Annotation) {
            this._format((Annotation)it, document);
            return;
        }
        if (it instanceof AnnotationType) {
            this._format((AnnotationType)it, document);
            return;
        }
        if (it instanceof Documentation) {
            this._format((Documentation)it, document);
            return;
        }
        if (it instanceof Import) {
            this._format((Import)it, document);
            return;
        }
        if (it instanceof DetailCode) {
            this._format((DetailCode)it, document);
            return;
        }
        if (it instanceof ProtocolSemantics) {
            this._format((ProtocolSemantics)it, document);
            return;
        }
        if (it instanceof StateGraph) {
            this._format((StateGraph)it, document);
            return;
        }
        if (it instanceof Trigger) {
            this._format((Trigger)it, document);
            return;
        }
        if (it instanceof EObject) {
            this._format((EObject)it, document);
            return;
        }
        if (it == null) {
            this._format(null, document);
            return;
        }
        if (it != null) {
            this._format(it, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, document).toString());
    }
}

