/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.diagram;

import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.IGraphLayoutEngine;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.VolatileLayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.diagram.LayoutMapping;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.service.LayoutOptionManager;
import de.cau.cs.kieler.kiml.ui.util.MonitoredOperation;
import de.cau.cs.kieler.kiml.ui.util.ProgressMonitorAdapter;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramLayoutEngine {
    public static final DiagramLayoutEngine INSTANCE = new DiagramLayoutEngine();
    public static final IProperty<IDiagramLayoutManager<?>> DIAGRAM_LM = new Property("layoutEngine.diagramLayoutManager");
    private static final int MAX_PROGRESS_LEVELS = 3;
    private static final int MIN_ANIMATION_TIME = 400;
    private static final int MAX_ANIMATION_TIME = 4000;
    private static final double ANIM_FACT = 100.0;
    private LayoutOptionManager layoutOptionManager = new LayoutOptionManager();
    public static final IProperty<IKielerProgressMonitor> PROGRESS_MONITOR = new Property("layout.progressMonitor");
    private static final float CONFIGURE_WORK = 1.0f;
    private static final float LAYOUT_WORK = 4.0f;
    private static final float TOTAL_WORK = 5.0f;
    private List<IListener> layoutListeners = new LinkedList<IListener>();

    public LayoutMapping<?> layout(IWorkbenchPart workbenchPart, Object diagramPart, boolean animate, boolean progressBar, boolean layoutAncestors, boolean zoom) {
        return this.layout(workbenchPart, diagramPart, animate, progressBar, layoutAncestors, zoom, null);
    }

    public LayoutMapping<?> layout(IWorkbenchPart workbenchPart, Object diagramPart, boolean animate, boolean progressBar, boolean layoutAncestors, boolean zoom, List<ILayoutConfig> extraLayoutConfigs) {
        IDiagramLayoutManager<?> layoutManager = EclipseLayoutInfoService.getInstance().getManager(workbenchPart, diagramPart);
        if (layoutManager != null) {
            LayoutMapping<?> mapping = this.layout(layoutManager, workbenchPart, diagramPart, animate, progressBar, layoutAncestors, zoom, extraLayoutConfigs);
            if (mapping != null) {
                mapping.setProperty(DIAGRAM_LM, layoutManager);
            }
            return mapping;
        }
        Status status = new Status(4, "de.cau.cs.kieler.kiml.ui", workbenchPart == null ? Messages.getString("kiml.ui.17") : String.valueOf(Messages.getString("kiml.ui.15")) + workbenchPart.getTitle() + ".");
        StatusManager.getManager().handle((IStatus)status, 2);
        return null;
    }

    protected <T> LayoutMapping<T> layout(final IDiagramLayoutManager<T> layoutManager, final IWorkbenchPart workbenchPart, final Object diagramPart, final boolean animate, boolean progressBar, final boolean layoutAncestors, final boolean zoom, final List<ILayoutConfig> extraLayoutConfigs) {
        final Maybe layoutMapping = Maybe.create();
        MonitoredOperation monitoredOperation = new MonitoredOperation(){

            protected void preUIexec() {
                layoutMapping.set(layoutManager.buildLayoutGraph(workbenchPart, layoutAncestors ? null : diagramPart));
            }

            protected IStatus execute(IProgressMonitor monitor) {
                Status status;
                Object kielerMonitor = monitor == null ? new BasicProgressMonitor(0) : new ProgressMonitorAdapter(monitor, 3);
                LayoutMapping mapping = (LayoutMapping)((Object)layoutMapping.get());
                if (mapping != null && mapping.getLayoutGraph() != null) {
                    Class[] adapterList = layoutManager.getAdapterList();
                    if (!$assertionsDisabled && adapterList.length <= 0) {
                        throw new AssertionError();
                    }
                    Object transDiagPart = layoutManager.getAdapter(diagramPart, adapterList[0]);
                    status = DiagramLayoutEngine.this.layout(mapping, transDiagPart, (IKielerProgressMonitor)kielerMonitor, extraLayoutConfigs, layoutAncestors);
                } else {
                    status = new Status(2, "de.cau.cs.kieler.kiml.ui", Messages.getString("kiml.ui.62"));
                }
                kielerMonitor.done();
                return status;
            }

            protected void postUIexec() {
                if (layoutMapping.get() != null) {
                    boolean withAnimation = animate && workbenchPart != null && workbenchPart.getSite().getPage().isPartVisible(workbenchPart);
                    int animationTime = DiagramLayoutEngine.calcAnimationTime((LayoutMapping)((Object)layoutMapping.get()), withAnimation);
                    layoutManager.applyLayout((LayoutMapping)((Object)layoutMapping.get()), zoom, animationTime);
                }
            }
        };
        if (progressBar) {
            monitoredOperation.runMonitored();
        } else {
            monitoredOperation.runUnmonitored();
        }
        return (LayoutMapping)((Object)layoutMapping.get());
    }

    private static int calcAnimationTime(LayoutMapping<?> mapping, boolean animate) {
        if (animate) {
            int graphSize = DiagramLayoutEngine.countNodes(mapping.getLayoutGraph());
            int time = 400 + (int)(100.0 * Math.sqrt(graphSize));
            return time <= 4000 ? time : 4000;
        }
        return 0;
    }

    private static int countNodes(KNode node) {
        int count = 0;
        for (KNode child : node.getChildren()) {
            count += DiagramLayoutEngine.countNodes(child) + 1;
        }
        return count;
    }

    public IStatus layout(IWorkbenchPart workbenchPart, Object diagramPart, IKielerProgressMonitor progressMonitor) {
        IDiagramLayoutManager<?> layoutManager = EclipseLayoutInfoService.getInstance().getManager(workbenchPart, diagramPart);
        if (layoutManager != null) {
            return this.layout(layoutManager, workbenchPart, diagramPart, progressMonitor);
        }
        return new Status(4, "de.cau.cs.kieler.kiml.ui", Messages.getString("kiml.ui.17"));
    }

    protected <T> IStatus layout(IDiagramLayoutManager<T> layoutManager, IWorkbenchPart workbenchPart, Object diagramPart, IKielerProgressMonitor progressMonitor) {
        Status status;
        Object monitor = progressMonitor == null ? new BasicProgressMonitor(0) : progressMonitor;
        monitor.begin("Layout Diagram", 3.0f);
        IKielerProgressMonitor submon1 = monitor.subTask(1.0f);
        submon1.begin("Build layout graph", 1.0f);
        LayoutMapping<T> mapping = layoutManager.buildLayoutGraph(workbenchPart, diagramPart);
        if (mapping != null && mapping.getLayoutGraph() != null) {
            Class[] adapterList = layoutManager.getAdapterList();
            assert (adapterList.length > 0);
            Object transDiagPart = layoutManager.getAdapter(diagramPart, adapterList[0]);
            submon1.done();
            status = this.layout(mapping, transDiagPart, monitor.subTask(1.0f), null, false);
            IKielerProgressMonitor submon3 = monitor.subTask(1.0f);
            submon3.begin("Apply layout to the diagram", 1.0f);
            layoutManager.applyLayout(mapping, false, 0);
            submon3.done();
        } else {
            status = new Status(2, "de.cau.cs.kieler.kiml.ui", Messages.getString("kiml.ui.62"));
        }
        monitor.done();
        return status;
    }

    public LayoutOptionManager getOptionManager() {
        return this.layoutOptionManager;
    }

    protected IStatus layout(LayoutMapping<?> mapping, Object diagramPart, IKielerProgressMonitor progressMonitor, List<ILayoutConfig> extraLayoutConfigs, boolean layoutAncestors) {
        KGraphElement graphElem;
        if (layoutAncestors && (graphElem = (KGraphElement)mapping.getGraphMap().inverse().get(diagramPart)) instanceof KNode && ((KNode)graphElem).getParent() != null) {
            KNode parent;
            KNode node = (KNode)graphElem;
            VolatileLayoutConfig vlc = new VolatileLayoutConfig();
            do {
                parent = node.getParent();
                for (KNode child : parent.getChildren()) {
                    if (child == node) continue;
                    vlc.setValue(LayoutOptions.NO_LAYOUT, (Object)child, LayoutContext.GRAPH_ELEM, (Object)true);
                    vlc.setValue(LayoutOptions.SIZE_CONSTRAINT, (Object)child, LayoutContext.GRAPH_ELEM, (Object)SizeConstraint.FIXED);
                    vlc.setValue(LayoutOptions.PORT_CONSTRAINTS, (Object)child, LayoutContext.GRAPH_ELEM, (Object)PortConstraints.FIXED_POS);
                }
            } while ((node = parent).getParent() != null);
            mapping.getLayoutConfigs().add((ILayoutConfig)vlc);
        }
        mapping.setProperty(PROGRESS_MONITOR, progressMonitor);
        IStatus status = null;
        if (extraLayoutConfigs == null || extraLayoutConfigs.isEmpty()) {
            status = this.layout(mapping, progressMonitor);
        } else if (extraLayoutConfigs.size() == 1) {
            mapping.getLayoutConfigs().add(extraLayoutConfigs.get(0));
            status = this.layout(mapping, progressMonitor);
        } else {
            progressMonitor.begin(Messages.getString("kiml.ui.63"), 5.0f * (float)extraLayoutConfigs.size());
            for (ILayoutConfig config : extraLayoutConfigs) {
                mapping.getLayoutConfigs().add(config);
                status = this.layout(mapping, progressMonitor);
                if (!status.isOK()) break;
                mapping.getLayoutConfigs().remove(config);
            }
            progressMonitor.done();
        }
        for (IListener listener : this.layoutListeners) {
            listener.layoutDone(mapping.getLayoutGraph(), progressMonitor);
        }
        return status;
    }

    public IStatus layout(LayoutMapping<?> mapping, IKielerProgressMonitor progressMonitor) {
        boolean newTask = progressMonitor.begin(Messages.getString("kiml.ui.63"), 5.0f);
        if (mapping.getProperty(PROGRESS_MONITOR) == null) {
            mapping.setProperty(PROGRESS_MONITOR, progressMonitor);
        }
        IGraphLayoutEngine layoutEngine = EclipseLayoutInfoService.getInstance().getLayoutEngine();
        try {
            this.layoutOptionManager.configure(mapping, progressMonitor.subTask(1.0f));
            layoutEngine.layout(mapping.getLayoutGraph(), progressMonitor.subTask(4.0f));
            if (newTask) {
                progressMonitor.done();
            }
            if (progressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        catch (Throwable exception) {
            return new Status(4, "de.cau.cs.kieler.kiml.ui", Messages.getString("kiml.ui.1"), exception);
        }
    }

    public void addListener(IListener listener) {
        this.layoutListeners.add(listener);
    }

    public static interface IListener {
        public void layoutDone(KNode var1, IKielerProgressMonitor var2);
    }
}

