/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.klay.layered.components.AbstractGraphPlacer;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleRowGraphPlacer
extends AbstractGraphPlacer {
    SimpleRowGraphPlacer() {
    }

    @Override
    public LGraph combine(List<LGraph> components) {
        if (components.size() == 1) {
            LGraph graph = components.get(0);
            for (Layer layer : graph) {
                graph.getLayerlessNodes().addAll(layer.getNodes());
            }
            graph.getLayers().clear();
            return graph;
        }
        if (components.isEmpty()) {
            return new LGraph();
        }
        for (LGraph graph : components) {
            int priority = 0;
            for (Layer layer : graph) {
                for (LNode node : layer) {
                    priority += ((Integer)node.getProperty((IProperty)Properties.PRIORITY)).intValue();
                }
            }
            graph.id = priority;
        }
        Collections.sort(components, new Comparator<LGraph>(){

            @Override
            public int compare(LGraph graph1, LGraph graph2) {
                int prio = graph2.id - graph1.id;
                if (prio == 0) {
                    double size1 = graph1.getSize().x * graph1.getSize().y;
                    double size2 = graph2.getSize().x * graph2.getSize().y;
                    return Double.compare(size1, size2);
                }
                return prio;
            }
        });
        LGraph firstComponent = components.get(0);
        LGraph result = new LGraph(firstComponent);
        result.copyProperties((IPropertyHolder)firstComponent);
        result.getInsets().copy(firstComponent.getInsets());
        double maxRowWidth = 0.0;
        double totalArea = 0.0;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            maxRowWidth = Math.max(maxRowWidth, size.x);
            totalArea += size.x * size.y;
        }
        maxRowWidth = Math.max(maxRowWidth, (double)((float)Math.sqrt(totalArea) * ((Float)result.getProperty((IProperty)Properties.ASPECT_RATIO)).floatValue()));
        double spacing = 2.0f * ((Float)result.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = spacing;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth) {
                xpos = 0.0;
                ypos += highestBox + spacing;
                highestBox = 0.0;
            }
            this.moveGraph(result, graph, xpos, ypos);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + spacing;
        }
        result.getSize().x = broadestRow;
        result.getSize().y = ypos + highestBox;
        return result;
    }
}

