/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p1cycles;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveCycleBreaker
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(5, EnumSet.of(LayoutProcessorStrategy.REVERSED_EDGE_RESTORER));

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Interactive cycle breaking", 1.0f);
        LinkedList<LEdge> revEdges = new LinkedList<LEdge>();
        for (LNode source : layeredGraph.getLayerlessNodes()) {
            source.id = 1;
            double sourcex = source.getInteractiveReferencePoint((LGraph)layeredGraph).x;
            for (LPort port : source.getPorts(PortType.OUTPUT)) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    double targetx;
                    LNode target = edge.getTarget().getNode();
                    if (target == source || !((targetx = target.getInteractiveReferencePoint((LGraph)layeredGraph).x) < sourcex)) continue;
                    revEdges.add(edge);
                }
            }
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
        }
        revEdges.clear();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.id <= 0) continue;
            this.findCycles(node, revEdges);
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
        }
        revEdges.clear();
        this.getMonitor().done();
    }

    private void findCycles(LNode node1, List<LEdge> revEdges) {
        node1.id = -1;
        for (LPort port : node1.getPorts(PortType.OUTPUT)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode node2 = edge.getTarget().getNode();
                if (node1 == node2) continue;
                if (node2.id < 0) {
                    revEdges.add(edge);
                    continue;
                }
                if (node2.id <= 0) continue;
                this.findCycles(node2, revEdges);
            }
        }
        node1.id = 0;
    }
}

