/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.formats;

import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.service.formats.ITransformationHandler;
import de.cau.cs.kieler.kiml.service.formats.TransformationData;
import de.cau.cs.kieler.kiml.service.formats.TransformationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmfHandler<T extends EObject>
implements ITransformationHandler<T> {
    private String fileExtension;

    @Override
    public void deserialize(String serializedGraph, TransformationData<T, KNode> transData) {
        try {
            ByteArrayInputStream source = new ByteArrayInputStream(serializedGraph.getBytes("UTF-8"));
            T result = this.deserializeBinary(source, null);
            source.close();
            transData.setSourceGraph(result);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformationException(e);
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public String serialize(T graph) {
        try {
            ByteArrayOutputStream target = new ByteArrayOutputStream();
            this.serializeBinary(graph, target, null);
            target.flush();
            String result = target.toString("UTF-8");
            target.close();
            return result;
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
    }

    public final void setFileExtension(String ext) {
        this.fileExtension = ext;
    }

    protected String getFileExtension() {
        return this.fileExtension;
    }

    protected final T deserializeBinary(InputStream source, Map<Object, Object> options) throws IOException {
        URI uri = URI.createURI((String)("temp." + this.getFileExtension()));
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.createResource(uri);
        HashMap<Object, Object> optMap = new HashMap<Object, Object>();
        optMap.put("RECORD_UNKNOWN_FEATURE", true);
        if (options != null) {
            optMap.putAll(options);
        }
        resource.load(source, optMap);
        if (!resource.getErrors().isEmpty()) {
            StringBuilder message = new StringBuilder("The given input could not be parsed.");
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                message.append("\n");
                if (diagnostic.getLine() > 0) {
                    message.append(diagnostic.getLine());
                    try {
                        if (diagnostic.getColumn() > 0) {
                            message.append(":");
                            message.append(diagnostic.getColumn());
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                    message.append(" - ");
                }
                message.append(diagnostic.getMessage());
            }
            throw new TransformationException(message.toString());
        }
        if (resource.getContents().isEmpty()) {
            return null;
        }
        return (T)((EObject)resource.getContents().get(0));
    }

    protected final void serializeBinary(T graph, OutputStream target, Map<Object, Object> options) throws IOException {
        EcoreUtil.resolveAll(graph);
        URI uri = URI.createURI((String)("temp." + this.getFileExtension()));
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add(graph);
        HashMap<Object, Object> optMap = new HashMap<Object, Object>();
        optMap.put("ENCODING", "UTF-8");
        if (options != null) {
            optMap.putAll(options);
        }
        resource.save(target, optMap);
    }

    protected abstract ResourceSet createResourceSet();
}

