/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiconnectedComponentsAnalysis
implements IAnalysis {
    private int nextDfsnum = 0;
    private Map<KNode, Integer> dfsMap = new HashMap<KNode, Integer>();
    private int[] lowpt;
    private int[] parent;

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Biconnected Components Analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int count = this.findComponents(parentNode, hierarchy);
        this.dfsMap.clear();
        this.lowpt = null;
        this.parent = null;
        progressMonitor.done();
        return count;
    }

    public int findComponents(KNode graph, boolean hierarchy) {
        this.nextDfsnum = 1;
        int graphSize = graph.getChildren().size();
        this.lowpt = new int[graphSize + 1];
        this.parent = new int[graphSize + 1];
        int count = 0;
        for (KNode node : graph.getChildren()) {
            if (this.dfsMap.get(node) != null) continue;
            count += this.dfsVisit(node);
        }
        if (hierarchy) {
            for (KNode node : graph.getChildren()) {
                if (node.getChildren().isEmpty()) continue;
                count += this.findComponents(node, true);
            }
        }
        return count;
    }

    private int dfsVisit(KNode node) {
        int dfsNum = this.nextDfsnum++;
        this.dfsMap.put(node, dfsNum);
        this.lowpt[dfsNum] = dfsNum;
        int count = 0;
        for (KEdge edge : Iterables.concat((Iterable)node.getOutgoingEdges(), (Iterable)node.getIncomingEdges())) {
            KNode endpoint;
            KNode kNode = endpoint = edge.getSource() == node ? edge.getTarget() : edge.getSource();
            if (endpoint.getParent() != node.getParent()) continue;
            Integer endpointNum = this.dfsMap.get(endpoint);
            if (endpointNum == null) {
                endpointNum = this.nextDfsnum;
                this.parent[endpointNum.intValue()] = dfsNum;
                count += this.dfsVisit(endpoint);
                this.lowpt[dfsNum] = Math.min(this.lowpt[dfsNum], this.lowpt[endpointNum]);
                continue;
            }
            this.lowpt[dfsNum] = Math.min(this.lowpt[dfsNum], endpointNum);
        }
        if (dfsNum >= 2 && this.lowpt[dfsNum] == this.parent[dfsNum]) {
            ++count;
        }
        return count;
    }
}

