/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundNodeChildCountAnalysis
implements IAnalysis {
    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Compound node child count analysis", 1.0f);
        int minimum = Integer.MAX_VALUE;
        int maximum = Integer.MIN_VALUE;
        int childNodes = 0;
        int compoundNodes = 0;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            EList children = node.getChildren();
            if (children.isEmpty()) continue;
            ++compoundNodes;
            nodeQueue.addAll(children);
            childNodes += children.size();
            minimum = Math.min(minimum, children.size());
            maximum = Math.max(maximum, children.size());
        }
        if ((compoundNodes = Math.max(0, compoundNodes - 1)) == 0) {
            minimum = 0;
            maximum = 0;
        }
        float avg = compoundNodes == 0 ? 0.0f : (float)childNodes / (float)compoundNodes;
        progressMonitor.done();
        return new Object[]{minimum, Float.valueOf(avg), maximum};
    }
}

