/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEdgeCountAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.multiEdgeCount";

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Multi Edge Count Analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int multiEdgeCount = 0;
        for (KNode node : parentNode.getChildren()) {
            multiEdgeCount += this.countMultiEdges(node, hierarchy);
        }
        progressMonitor.done();
        return multiEdgeCount;
    }

    public int countMultiEdges(KNode node, boolean hierarchy) {
        int multiEdges = 0;
        ArrayList edges = new ArrayList();
        edges.addAll(node.getOutgoingEdges());
        Collections.sort(edges, new KEdgeComparator());
        KNode lastTargetNode = null;
        KPort lastSourcePort = null;
        KPort lastTargetPort = null;
        int edgesConnectingTwoPorts = 0;
        for (KEdge edge : edges) {
            if (edge.getTarget() == lastTargetNode && edge.getSourcePort() == lastSourcePort && edge.getTargetPort() == lastTargetPort) {
                ++edgesConnectingTwoPorts;
            } else {
                if (edgesConnectingTwoPorts > 1) {
                    multiEdges += edgesConnectingTwoPorts;
                }
                edgesConnectingTwoPorts = 1;
            }
            lastTargetNode = edge.getTarget();
            lastSourcePort = edge.getSourcePort();
            lastTargetPort = edge.getTargetPort();
        }
        if (edgesConnectingTwoPorts > 1) {
            multiEdges += edgesConnectingTwoPorts;
        }
        if (hierarchy) {
            for (KNode child : node.getChildren()) {
                multiEdges += this.countMultiEdges(child, true);
            }
        }
        return multiEdges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KEdgeComparator
    implements Comparator<KEdge> {
        private KEdgeComparator() {
        }

        @Override
        public int compare(KEdge o1, KEdge o2) {
            KPort sourcePort1 = o1.getSourcePort();
            KPort sourcePort2 = o2.getSourcePort();
            KNode targetNode1 = o1.getTarget();
            KNode targetNode2 = o2.getTarget();
            KPort targetPort1 = o1.getTargetPort();
            KPort targetPort2 = o2.getTargetPort();
            if (sourcePort1 == null && sourcePort2 != null) {
                return -1;
            }
            if (sourcePort1 != null && sourcePort2 == null) {
                return 1;
            }
            if (sourcePort1 != null && sourcePort2 != null && !sourcePort1.equals(sourcePort2)) {
                return sourcePort1.hashCode() < sourcePort2.hashCode() ? -1 : 1;
            }
            if (!targetNode1.equals(targetNode2)) {
                return targetNode1.hashCode() < targetNode2.hashCode() ? -1 : 1;
            }
            if (targetPort1 == null && targetPort2 != null) {
                return -1;
            }
            if (targetPort1 != null && targetPort2 == null) {
                return 1;
            }
            if (targetPort1 != null && targetPort2 != null && !targetPort1.equals(targetPort2)) {
                return targetPort1.hashCode() < targetPort2.hashCode() ? -1 : 1;
            }
            return 0;
        }
    }
}

