/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.timesquare.ccsl.sat.IClock;
import fr.kairos.timesquare.ccsl.sat.IClockBuilder;
import fr.kairos.timesquare.ccsl.sat.INameToIntegerMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

final class ClockCollector
implements Iterable<IClock>,
INameToIntegerMapper {
    private HashMap<String, Integer> namesToId = new HashMap();
    private ArrayList<IClock> clocks = new ArrayList();
    private ArrayList<String> names = new ArrayList();
    private IClockBuilder clockBuilder;

    ClockCollector(IClockBuilder clockBuilder) {
        this.clockBuilder = clockBuilder;
    }

    private int addClock(String name) {
        Integer i = this.namesToId.get(name);
        if (i == null) {
            i = this.clocks.size();
            this.namesToId.put(name, i);
            this.clocks.add(this.clockBuilder.buildClock(name));
            this.names.add(name);
        }
        return i;
    }

    @Override
    public Iterator<IClock> iterator() {
        return this.clocks.iterator();
    }

    @Override
    public int getIdFromName(String name) {
        return this.addClock(name);
    }

    IClock nameToClock(String name) {
        return this.idToClock(this.addClock(name));
    }

    IClock idToClock(int id) {
        return this.clocks.get(id);
    }

    @Override
    public String getNameFromId(int id) {
        return this.names.get(id);
    }

    @Override
    public int size() {
        return this.names.size();
    }
}

