/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.features;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.examples.mm.filesystem.File;
import org.eclipse.graphiti.examples.mm.filesystem.Filesystem;
import org.eclipse.graphiti.examples.mm.filesystem.Folder;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class CreateContainmentConnectionFeature
extends AbstractCreateConnectionFeature
implements ICreateConnectionFeature {
    public CreateContainmentConnectionFeature(IFeatureProvider fp) {
        super(fp, "Containment", "Creates a new containment relation between two folders");
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        Object domainObject = this.getBusinessObjectForPictogramElement(context.getSourcePictogramElement());
        return domainObject instanceof Folder || domainObject instanceof Filesystem;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        PictogramElement sourcePictogramElement = context.getSourcePictogramElement();
        PictogramElement targetPictogramElement = context.getTargetPictogramElement();
        if (sourcePictogramElement == null || targetPictogramElement == null) {
            return false;
        }
        Object sourceDomainObject = this.getBusinessObjectForPictogramElement(sourcePictogramElement);
        Object targetDomainObject = this.getBusinessObjectForPictogramElement(targetPictogramElement);
        return !(!(sourceDomainObject instanceof Folder) && !(sourceDomainObject instanceof Filesystem) || !(targetDomainObject instanceof Folder) && !(targetDomainObject instanceof File));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection create(ICreateConnectionContext context) {
        Anchor sourceAnchor = context.getSourceAnchor();
        Anchor targetAnchor = context.getTargetAnchor();
        if (targetAnchor == null) {
            Shape shape = (Shape)context.getTargetPictogramElement();
            while (shape.getAnchors().isEmpty()) {
                shape = shape.getContainer();
            }
            targetAnchor = (Anchor)shape.getAnchors().get(0);
        }
        EObject sourceObject = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)sourceAnchor.getParent());
        EObject targetObject = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)targetAnchor.getParent());
        if (sourceObject instanceof Filesystem) {
            if (targetObject instanceof Folder) {
                ((Filesystem)sourceObject).getFolders().add((Object)((Folder)targetObject));
            } else {
                if (!(targetObject instanceof File)) throw new IllegalStateException("Filesystem may only contain Folders or Files");
                ((Filesystem)sourceObject).getFiles().add((Object)((File)targetObject));
            }
        } else {
            if (!(sourceObject instanceof Folder)) throw new IllegalStateException("Unknown container object");
            if (targetObject instanceof Folder) {
                ((Folder)sourceObject).getFolders().add((Object)((Folder)targetObject));
            } else {
                if (!(targetObject instanceof File)) throw new IllegalStateException("Folder may only contain Folders or Files");
                ((Folder)sourceObject).getFiles().add((Object)((File)targetObject));
            }
        }
        AddConnectionContext addContext = new AddConnectionContext(sourceAnchor, targetAnchor);
        this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        return null;
    }
}

