/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.search;

import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.handly.ui.preference.ScopedPreferenceStore;
import org.eclipse.handly.ui.search.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.PlatformUI;

public class BaseSearchLabelProvider
extends BaseLabelProvider {
    private static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    private static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    private final AbstractTextSearchViewPage page;
    private IPreferenceStore searchPreferences;
    private IPropertyChangeListener searchPropertyChangeListener;
    private Color potentialMatchFgColor;

    public BaseSearchLabelProvider(AbstractTextSearchViewPage page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.page = page;
        this.searchPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.search");
        this.searchPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (BaseSearchLabelProvider.POTENTIAL_MATCH_FG_COLOR.equals(event.getProperty()) || BaseSearchLabelProvider.EMPHASIZE_POTENTIAL_MATCHES.equals(event.getProperty())) {
                    if (BaseSearchLabelProvider.this.potentialMatchFgColor != null) {
                        BaseSearchLabelProvider.this.potentialMatchFgColor.dispose();
                        BaseSearchLabelProvider.this.potentialMatchFgColor = null;
                    }
                    BaseSearchLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BaseSearchLabelProvider.this, null));
                }
            }
        };
        this.searchPreferences.addPropertyChangeListener(this.searchPropertyChangeListener);
    }

    public void dispose() {
        if (this.potentialMatchFgColor != null) {
            this.potentialMatchFgColor.dispose();
            this.potentialMatchFgColor = null;
        }
        if (this.searchPreferences != null && this.searchPropertyChangeListener != null) {
            this.searchPreferences.removePropertyChangeListener(this.searchPropertyChangeListener);
            this.searchPreferences = null;
            this.searchPropertyChangeListener = null;
        }
        super.dispose();
    }

    public AbstractTextSearchViewPage getPage() {
        return this.page;
    }

    public Color getForeground(Object element) {
        if (this.isEmphasizePotentialMatches() && this.getPotentialMatchCount(element) > 0) {
            return this.getPotentialMatchForegroundColor();
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public String getLabelWithCounts(Object element, String elementName) {
        int matchCount = this.page.getDisplayedMatchCount(element);
        int potentialMatchCount = this.getPotentialMatchCount(element);
        if (matchCount < 2) {
            if (potentialMatchCount > 0) {
                return MessageFormat.format(Messages.BaseSearchLabelProvider_Element__0__potential_match, elementName);
            }
            return elementName;
        }
        int exactMatchCount = matchCount - potentialMatchCount;
        if (potentialMatchCount > 0 && exactMatchCount > 0) {
            return MessageFormat.format(Messages.BaseSearchLabelProvider_Element__0__matches__1__exact__2__potential__3, elementName, matchCount, exactMatchCount, potentialMatchCount);
        }
        if (exactMatchCount == 0) {
            return MessageFormat.format(Messages.BaseSearchLabelProvider_Element__0__potential_matches__1, elementName, potentialMatchCount);
        }
        return MessageFormat.format(Messages.BaseSearchLabelProvider_Element__0__exact_matches__1, elementName, matchCount);
    }

    public StyledString getColoredLabelWithCounts(Object element, StyledString coloredName) {
        String name = coloredName.getString();
        String decorated = this.getLabelWithCounts(element, name);
        if (decorated.length() > name.length()) {
            StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)coloredName);
        }
        return coloredName;
    }

    protected boolean isPotentialMatch(Match match) {
        return false;
    }

    private int getPotentialMatchCount(Object element) {
        Match[] matches;
        AbstractTextSearchResult result = this.page.getInput();
        if (result == null) {
            return 0;
        }
        int potentialMatchCount = 0;
        Match[] matchArray = matches = result.getMatches(element);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (this.isPotentialMatch(match)) {
                ++potentialMatchCount;
            }
            ++n2;
        }
        return potentialMatchCount;
    }

    private Color getPotentialMatchForegroundColor() {
        if (this.potentialMatchFgColor == null) {
            this.potentialMatchFgColor = new Color((Device)PlatformUI.getWorkbench().getDisplay(), PreferenceConverter.getColor((IPreferenceStore)this.searchPreferences, (String)POTENTIAL_MATCH_FG_COLOR));
        }
        return this.potentialMatchFgColor;
    }

    private boolean isEmphasizePotentialMatches() {
        return this.searchPreferences.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }
}

