/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.dt.http;

import java.security.Principal;
import java.util.List;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.Credentials;
import org.eclipse.hawk.service.api.dt.Activator;
import org.eclipse.hawk.service.api.dt.prefs.CredentialsStore;
import org.eclipse.hawk.service.api.dt.prefs.Server;
import org.eclipse.hawk.service.api.dt.prefs.ServerStore;
import org.eclipse.hawk.service.api.dt.ui.ServerConfigurationDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LazyCredentials
implements Credentials {
    private final String url;
    private Principal principal;
    private String password;

    public LazyCredentials(String url) {
        this.url = url;
    }

    public Principal getUserPrincipal() {
        if (this.principal == null) {
            this.getCredentials();
            if (this.principal == null) {
                return new BasicUserPrincipal("");
            }
        }
        return this.principal;
    }

    public String getPassword() {
        if (this.password == null) {
            this.getCredentials();
            if (this.password == null) {
                return "";
            }
        }
        return this.password;
    }

    public Principal getRawUserPrincipal() {
        return this.principal;
    }

    public String getRawPassword() {
        return this.password;
    }

    protected void getCredentials() {
        try {
            List<Server> servers = Activator.getDefault().getServerStore().readAllServers();
            String storeKey = this.url;
            for (Server server : servers) {
                if (!this.url.startsWith(server.getBaseURL())) continue;
                storeKey = server.getBaseURL();
                break;
            }
            CredentialsStore.Credentials creds = Activator.getDefault().getCredentialsStore().get(storeKey);
            if (creds == null && PlatformUI.isWorkbenchRunning()) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                CredentialsPrompter prompter = new CredentialsPrompter(display);
                display.syncExec((Runnable)prompter);
                creds = prompter.getCredentials();
            }
            if (creds != null) {
                this.principal = new BasicUserPrincipal(creds.getUsername());
                this.password = creds.getPassword();
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
    }

    private final class CredentialsPrompter
    implements Runnable {
        private final Display display;
        private CredentialsStore.Credentials creds;

        private CredentialsPrompter(Display display) {
            this.display = display;
        }

        @Override
        public void run() {
            ServerConfigurationDialog dlg = new ServerConfigurationDialog(this.display.getActiveShell(), "Authentication required", LazyCredentials.this.url);
            if (dlg.open() == 0) {
                ServerStore serverStore = Activator.getDefault().getServerStore();
                List<Server> servers = serverStore.readAllServers();
                servers.add(new Server(dlg.getLocation()));
                serverStore.saveAllServers(servers);
                this.creds = new CredentialsStore.Credentials(dlg.getUsername(), dlg.getPassword());
                try {
                    CredentialsStore credentialsStore = Activator.getDefault().getCredentialsStore();
                    credentialsStore.put(LazyCredentials.this.url, this.creds);
                    credentialsStore.flush();
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
            }
        }

        public CredentialsStore.Credentials getCredentials() {
            return this.creds;
        }
    }
}

