/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.dt.prefs;

import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CredentialsStore {
    private static final String PASSWORD_SUFFIX = ".password";
    private static final String USERNAME_SUFFIX = ".username";
    private ISecurePreferences preferences;

    public void put(String repositoryKey, Credentials creds) throws Exception {
        this.checkOpen();
        String encodedPrefix = EncodingUtils.encodeSlashes((String)repositoryKey);
        this.preferences.put(String.valueOf(encodedPrefix) + USERNAME_SUFFIX, creds.getUsername(), true);
        this.preferences.put(String.valueOf(encodedPrefix) + PASSWORD_SUFFIX, creds.getPassword(), true);
        this.preferences.flush();
    }

    public Credentials get(String repositoryKey) throws Exception {
        this.checkOpen();
        String encodedPrefix = EncodingUtils.encodeSlashes((String)repositoryKey);
        String username = this.preferences.get(String.valueOf(encodedPrefix) + USERNAME_SUFFIX, null);
        String password = this.preferences.get(String.valueOf(encodedPrefix) + PASSWORD_SUFFIX, null);
        if (username != null && password != null) {
            return new Credentials(username, password);
        }
        return null;
    }

    public void remove(String repositoryKey) throws Exception {
        this.checkOpen();
        String encodedPrefix = EncodingUtils.encodeSlashes((String)repositoryKey);
        this.preferences.remove(String.valueOf(encodedPrefix) + USERNAME_SUFFIX);
        this.preferences.remove(String.valueOf(encodedPrefix) + PASSWORD_SUFFIX);
    }

    public void flush() throws Exception {
        if (this.preferences != null) {
            this.preferences.flush();
        }
    }

    private void checkOpen() {
        if (this.preferences != null) {
            return;
        }
        Bundle bundle = FrameworkUtil.getBundle(CredentialsStore.class);
        this.preferences = SecurePreferencesFactory.getDefault().node(bundle.getSymbolicName());
    }

    public static class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

