/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.dt.ui;

import java.util.List;
import org.eclipse.hawk.service.api.dt.Activator;
import org.eclipse.hawk.service.api.dt.prefs.CredentialsStore;
import org.eclipse.hawk.service.api.dt.prefs.Server;
import org.eclipse.hawk.service.api.dt.prefs.ServerStore;
import org.eclipse.hawk.service.api.dt.ui.ServerConfigurationDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HawkServersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ServerStore serverStore;
    private List<Server> servers;
    private CredentialsStore credsStore;

    public HawkServersPreferencePage() {
    }

    public HawkServersPreferencePage(String title) {
        super(title);
    }

    public HawkServersPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        IPreferenceStore preferencesStore = Activator.getDefault().getPreferenceStore();
        this.serverStore = new ServerStore(preferencesStore);
        this.credsStore = Activator.getDefault().getCredentialsStore();
        this.noDefaultButton();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.servers = this.serverStore.readAllServers();
        final ListViewer lServerURLs = new ListViewer(composite);
        lServerURLs.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        lServerURLs.setContentProvider((IContentProvider)new ListContentProvider());
        lServerURLs.setInput(this.servers);
        lServerURLs.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite cButtons = new Composite(composite, 0);
        cButtons.setLayoutData((Object)new GridData(16384, 128, true, false));
        cButtons.setLayout((Layout)new FillLayout(256));
        Button btnAdd = new Button(cButtons, 0);
        btnAdd.setText("Add...");
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ServerConfigurationDialog scDialog = new ServerConfigurationDialog(shell, "Add server", "http://localhost:8080/");
                if (scDialog.open() == 0) {
                    Server newServer = new Server(scDialog.getLocation());
                    try {
                        HawkServersPreferencePage.this.credsStore.put(scDialog.getLocation(), scDialog.getCredentials());
                        HawkServersPreferencePage.this.servers.add(newServer);
                        lServerURLs.setInput((Object)HawkServersPreferencePage.this.servers);
                    }
                    catch (Exception ex) {
                        Activator.getDefault().logError(ex);
                    }
                }
            }
        });
        Button btnRemove = new Button(cButtons, 0);
        btnRemove.setText("Remove");
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = lServerURLs.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)lServerURLs.getSelection();
                    Server server = (Server)ssel.getFirstElement();
                    try {
                        HawkServersPreferencePage.this.credsStore.remove(server.getBaseURL());
                        HawkServersPreferencePage.this.servers.remove(server);
                        lServerURLs.setInput((Object)HawkServersPreferencePage.this.servers);
                    }
                    catch (Exception ex) {
                        Activator.getDefault().logError(ex);
                    }
                }
            }
        });
        Button btnEdit = new Button(cButtons, 0);
        btnEdit.setText("Edit...");
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = lServerURLs.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)lServerURLs.getSelection();
                    Server server = (Server)ssel.getFirstElement();
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ServerConfigurationDialog scDialog = new ServerConfigurationDialog(shell, "Add server", "http://localhost:8080/");
                    try {
                        CredentialsStore.Credentials creds = HawkServersPreferencePage.this.credsStore.get(server.getBaseURL());
                        if (creds != null) {
                            scDialog.setCredentials(creds);
                        }
                    }
                    catch (Exception ex) {
                        Activator.getDefault().logError(ex);
                    }
                    if (scDialog.open() == 0) {
                        try {
                            HawkServersPreferencePage.this.credsStore.put(server.getBaseURL(), scDialog.getCredentials());
                        }
                        catch (Exception ex) {
                            Activator.getDefault().logError(ex);
                        }
                    }
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean performOk() {
        try {
            this.credsStore.flush();
            this.serverStore.saveAllServers(this.servers);
            return super.performOk();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
            return false;
        }
    }

    private static final class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)inputElement;
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class ServerLabelProvider
    extends LabelProvider {
        private ServerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Server) {
                return ((Server)element).getBaseURL();
            }
            return super.getText(element);
        }
    }
}

